/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.RequestedClaimAdditionalInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CustomClaimRequest
extends ClaimsRequest {
    protected void requestClaimInAccessToken(String claim, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        super.requestClaimInAccessToken(claim, requestedClaimAdditionalInfo);
    }

    public static ClaimsRequest formatAsClaimsRequest(String claims) {
        try {
            CustomClaimRequest cr = new CustomClaimRequest();
            ObjectMapper mapper = new ObjectMapper();
            ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<String>>(){});
            JsonNode jsonClaims = mapper.readTree(claims);
            CustomClaimRequest.addClaimsFromJsonNode(jsonClaims.get("id_token"), "id_token", cr, reader);
            CustomClaimRequest.addClaimsFromJsonNode(jsonClaims.get("userinfo"), "userinfo", cr, reader);
            CustomClaimRequest.addClaimsFromJsonNode(jsonClaims.get("access_token"), "access_token", cr, reader);
            return cr;
        }
        catch (IOException e) {
            throw new MsalClientException("Could not convert string to ClaimsRequest: " + e.getMessage(), "invalid_json");
        }
    }

    private static void addClaimsFromJsonNode(JsonNode claims, String group, CustomClaimRequest cr, ObjectReader reader) throws IOException {
        if (claims != null) {
            Iterator claimsIterator = claims.fieldNames();
            while (claimsIterator.hasNext()) {
                String claim = (String)claimsIterator.next();
                Boolean essential = null;
                String value = null;
                List values = null;
                RequestedClaimAdditionalInfo claimInfo = null;
                if (claims.get(claim).has("essential")) {
                    essential = claims.get(claim).get("essential").asBoolean();
                }
                if (claims.get(claim).has("value")) {
                    value = claims.get(claim).get("value").textValue();
                }
                if (claims.get(claim).has("values")) {
                    values = (List)reader.readValue(claims.get(claim).get("values"));
                }
                if (essential != null || value != null || values != null) {
                    claimInfo = new RequestedClaimAdditionalInfo(essential == null ? false : essential, value, values);
                }
                if (group.equals("id_token")) {
                    cr.requestClaimInIdToken(claim, claimInfo);
                }
                if (!group.equals("access_token")) continue;
                cr.requestClaimInAccessToken(claim, claimInfo);
            }
        }
    }
}

