/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IntelliJAuthMethodDetails;
import com.azure.identity.implementation.LinuxKeyRingAccessor;
import com.azure.identity.implementation.intellij.IntelliJKdbxDatabase;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IntelliJCacheAccessor {
    private final ClientLogger logger = new ClientLogger(IntelliJCacheAccessor.class);
    private String keePassDatabasePath;
    private static final String INTELLIJ_CREDENTIAL_NOT_AVAILABLE_ERROR = "IntelliJ Authentication not available. Please log in with Azure Tools for IntelliJ plugin in the IDE.";
    private static final byte[] CRYPTO_KEY = new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99};

    public IntelliJCacheAccessor(String keePassDatabasePath) {
        this.keePassDatabasePath = keePassDatabasePath;
    }

    private List<String> getAzureToolsforIntelliJPluginConfigPaths() {
        return Arrays.asList(Paths.get(System.getProperty("user.home"), "AzureToolsForIntelliJ").toString(), Paths.get(System.getProperty("user.home"), ".AzureToolsForIntelliJ").toString());
    }

    public JsonNode getDeviceCodeCredentials() throws IOException {
        if (Platform.isMac()) {
            KeyChainAccessor accessor = new KeyChainAccessor(null, "ADAuthManager", "cachedAuthResult");
            String jsonCred = new String(accessor.read(), Charset.forName("UTF-8"));
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonCred);
        }
        if (Platform.isLinux()) {
            LinuxKeyRingAccessor accessor = new LinuxKeyRingAccessor("com.intellij.credentialStore.Credential", "service", "ADAuthManager", "account", "cachedAuthResult");
            String jsonCred = new String(accessor.read(), Charset.forName("UTF-8"));
            if (jsonCred.startsWith("cachedAuthResult@")) {
                jsonCred = jsonCred.replaceFirst("cachedAuthResult@", "");
            }
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonCred);
        }
        if (Platform.isWindows()) {
            return this.getCredentialFromKdbx();
        }
        throw this.logger.logExceptionAsError(new RuntimeException(String.format("OS %s Platform not supported.", Platform.getOSType())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getIntellijServicePrincipalDetails(String credFilePath) throws IOException {
        HashMap<String, String> servicePrincipalDetails = new HashMap<String, String>(8);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(credFilePath));
            String line = reader.readLine();
            while (line != null) {
                String[] split = line.split("=");
                split[1] = split[1].replace("\\", "");
                servicePrincipalDetails.put(split[0], split[1]);
                line = reader.readLine();
            }
        }
        return servicePrincipalDetails;
    }

    private JsonNode getCredentialFromKdbx() throws IOException {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.keePassDatabasePath)) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("The KeePass database path is either empty or not configured. Please configure it on the builder. It is required to use IntelliJ credential on the windows platform.")));
        }
        String extractedpwd = this.getKdbxPassword();
        SecretKeySpec key = new SecretKeySpec(CRYPTO_KEY, "AES");
        String password = "";
        byte[] dataToDecrypt = Crypt32Util.cryptUnprotectData((byte[])Base64.getDecoder().decode(extractedpwd));
        ByteBuffer decryptBuffer = ByteBuffer.wrap(dataToDecrypt);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int ivLen = decryptBuffer.getInt();
            cipher.init(2, (Key)key, new IvParameterSpec(dataToDecrypt, decryptBuffer.position(), ivLen));
            int dataOffset = decryptBuffer.position() + ivLen;
            byte[] decrypted = cipher.doFinal(dataToDecrypt, dataOffset, dataToDecrypt.length - dataOffset);
            password = new String(decrypted, Charset.forName("UTF-8"));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw this.logger.logExceptionAsError(new RuntimeException("Unable to access cache.", e));
        }
        try {
            FileInputStream inputStream = new FileInputStream(new File(this.keePassDatabasePath));
            IntelliJKdbxDatabase kdbxDatabase = IntelliJKdbxDatabase.parse(inputStream, password);
            String jsonToken = kdbxDatabase.getDatabaseEntryValue("ADAuthManager");
            if (CoreUtils.isNullOrEmpty((CharSequence)jsonToken)) {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("No credentials found in the cache. Please login with IntelliJ Azure Tools plugin in the IDE.")));
            }
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonToken);
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError(new RuntimeException("Failed to read KeePass database.", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKdbxPassword() throws IOException {
        String passwordFilePath = new File(this.keePassDatabasePath).getParent() + File.separator + "c.pwd";
        String extractedpwd = "";
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(passwordFilePath));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("value")) {
                    String[] tokens = line.split(" ");
                    if (tokens.length == 3) {
                        extractedpwd = tokens[2];
                        break;
                    }
                    throw this.logger.logExceptionAsError(new RuntimeException("Password not found in the file."));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        return extractedpwd;
    }

    public String getAzureAuthHost(String azureEnvironment) {
        switch (azureEnvironment) {
            case "GLOBAL": {
                return "https://login.microsoftonline.com/";
            }
            case "CHINA": {
                return "https://login.chinacloudapi.cn/";
            }
            case "GERMAN": {
                return "https://login.microsoftonline.de/";
            }
            case "US_GOVERNMENT": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }

    public IntelliJAuthMethodDetails parseAuthMethodDetails(File file) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (IntelliJAuthMethodDetails)objectMapper.readValue(file, IntelliJAuthMethodDetails.class);
    }

    public IntelliJAuthMethodDetails getAuthDetailsIfAvailable() throws IOException {
        String metadataPath;
        String authMethodDetailsPath;
        File authFile = null;
        Iterator<String> iterator = this.getAzureToolsforIntelliJPluginConfigPaths().iterator();
        while (iterator.hasNext() && !(authFile = new File(authMethodDetailsPath = Paths.get(metadataPath = iterator.next(), "AuthMethodDetails.json").toString())).exists()) {
        }
        if (authFile == null || !authFile.exists()) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(INTELLIJ_CREDENTIAL_NOT_AVAILABLE_ERROR)));
        }
        IntelliJAuthMethodDetails authMethodDetails = this.parseAuthMethodDetails(authFile);
        String authType = authMethodDetails.getAuthMethod();
        if (CoreUtils.isNullOrEmpty((CharSequence)authType)) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(INTELLIJ_CREDENTIAL_NOT_AVAILABLE_ERROR)));
        }
        if (authType.equalsIgnoreCase("SP") ? CoreUtils.isNullOrEmpty((CharSequence)authMethodDetails.getCredFilePath()) : authType.equalsIgnoreCase("DC") && CoreUtils.isNullOrEmpty((CharSequence)authMethodDetails.getAccountEmail())) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException(INTELLIJ_CREDENTIAL_NOT_AVAILABLE_ERROR)));
        }
        return authMethodDetails;
    }
}

