/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.IdentityLogOptions;
import com.azure.identity.implementation.RegionalAuthority;
import com.azure.identity.implementation.util.ValidationUtil;
import com.microsoft.aad.msal4j.UserAssertion;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public final class IdentityClientOptions {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityClientOptions.class);
    private static final int MAX_RETRY_DEFAULT_LIMIT = 3;
    public static final String AZURE_IDENTITY_DISABLE_MULTI_TENANT_AUTH = "AZURE_IDENTITY_DISABLE_MULTITENANTAUTH";
    public static final String AZURE_POD_IDENTITY_AUTHORITY_HOST = "AZURE_POD_IDENTITY_AUTHORITY_HOST";
    private String authorityHost;
    private String imdsAuthorityHost;
    private int maxRetry;
    private Function<Duration, Duration> retryTimeout;
    private ProxyOptions proxyOptions;
    private HttpPipeline httpPipeline;
    private ExecutorService executorService;
    private HttpClient httpClient;
    private boolean allowUnencryptedCache;
    private boolean sharedTokenCacheEnabled;
    private String keePassDatabasePath;
    private boolean includeX5c;
    private AuthenticationRecord authenticationRecord;
    private TokenCachePersistenceOptions tokenCachePersistenceOptions;
    private boolean cp1Disabled;
    private RegionalAuthority regionalAuthority;
    private UserAssertion userAssertion;
    private boolean multiTenantAuthDisabled;
    private Configuration configuration;
    private IdentityLogOptions identityLogOptions;

    public IdentityClientOptions() {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.loadFromConfiguration(configuration);
        this.identityLogOptions = new IdentityLogOptions();
        this.maxRetry = 3;
        this.retryTimeout = i -> Duration.ofSeconds((long)Math.pow(2.0, i.getSeconds() - 1L));
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public IdentityClientOptions setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
        return this;
    }

    public String getImdsAuthorityHost() {
        return this.imdsAuthorityHost;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public IdentityClientOptions setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
        return this;
    }

    public Function<Duration, Duration> getRetryTimeout() {
        return this.retryTimeout;
    }

    public IdentityClientOptions setRetryTimeout(Function<Duration, Duration> retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public IdentityClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public IdentityClientOptions setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public IdentityClientOptions setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public IdentityClientOptions setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public IdentityClientOptions setAllowUnencryptedCache(boolean allowUnencryptedCache) {
        this.allowUnencryptedCache = allowUnencryptedCache;
        return this;
    }

    public boolean getAllowUnencryptedCache() {
        return this.allowUnencryptedCache;
    }

    public IdentityClientOptions setIntelliJKeePassDatabasePath(String keePassDatabasePath) {
        this.keePassDatabasePath = keePassDatabasePath;
        return this;
    }

    public boolean isSharedTokenCacheEnabled() {
        return this.sharedTokenCacheEnabled;
    }

    public IdentityClientOptions enablePersistentCache() {
        this.sharedTokenCacheEnabled = true;
        return this;
    }

    public String getIntelliJKeePassDatabasePath() {
        return this.keePassDatabasePath;
    }

    public IdentityClientOptions setAuthenticationRecord(AuthenticationRecord authenticationRecord) {
        this.authenticationRecord = authenticationRecord;
        return this;
    }

    public boolean isIncludeX5c() {
        return this.includeX5c;
    }

    public IdentityClientOptions setIncludeX5c(boolean includeX5c) {
        this.includeX5c = includeX5c;
        return this;
    }

    public AuthenticationRecord getAuthenticationRecord() {
        return this.authenticationRecord;
    }

    public IdentityClientOptions setTokenCacheOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.tokenCachePersistenceOptions = tokenCachePersistenceOptions;
        return this;
    }

    public TokenCachePersistenceOptions getTokenCacheOptions() {
        return this.tokenCachePersistenceOptions;
    }

    public boolean isCp1Disabled() {
        return this.cp1Disabled;
    }

    public IdentityClientOptions setRegionalAuthority(RegionalAuthority regionalAuthority) {
        this.regionalAuthority = regionalAuthority;
        return this;
    }

    public RegionalAuthority getRegionalAuthority() {
        return this.regionalAuthority;
    }

    public IdentityClientOptions userAssertion(String userAssertion) {
        this.userAssertion = new UserAssertion(userAssertion);
        return this;
    }

    public UserAssertion getUserAssertion() {
        return this.userAssertion;
    }

    public boolean isMultiTenantAuthenticationDisabled() {
        return this.multiTenantAuthDisabled;
    }

    public IdentityClientOptions disableMultiTenantAuthentication() {
        this.multiTenantAuthDisabled = true;
        return this;
    }

    public IdentityClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.loadFromConfiguration(configuration);
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public IdentityLogOptions getIdentityLogOptions() {
        return this.identityLogOptions;
    }

    public IdentityClientOptions setIdentityLogOptions(IdentityLogOptions identityLogOptions) {
        this.identityLogOptions = identityLogOptions;
        return this;
    }

    private void loadFromConfiguration(Configuration configuration) {
        this.authorityHost = (String)configuration.get("AZURE_AUTHORITY_HOST", (Object)"https://login.microsoftonline.com/");
        this.imdsAuthorityHost = (String)configuration.get(AZURE_POD_IDENTITY_AUTHORITY_HOST, (Object)"http://169.254.169.254");
        ValidationUtil.validateAuthHost(this.authorityHost, LOGGER);
        this.cp1Disabled = (Boolean)configuration.get("AZURE_IDENTITY_DISABLE_CP1", (Object)false);
        this.multiTenantAuthDisabled = (Boolean)configuration.get(AZURE_IDENTITY_DISABLE_MULTI_TENANT_AUTH, (Object)false);
    }
}

