/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.VisualStudioCodeCredential;
import com.azure.identity.implementation.util.ValidationUtil;

public class VisualStudioCodeCredentialBuilder
extends CredentialBuilderBase<VisualStudioCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredentialBuilder.class);
    private String tenantId;

    public VisualStudioCodeCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public VisualStudioCodeCredential build() {
        return new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions);
    }
}

