/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClientOptions;

public final class IdentityUtil {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityUtil.class);

    private IdentityUtil() {
    }

    public static String resolveTenantId(String currentTenantId, TokenRequestContext requestContext, IdentityClientOptions options) {
        String contextTenantId = requestContext.getTenantId();
        if (contextTenantId != null && currentTenantId != null && !currentTenantId.equals(contextTenantId)) {
            if (options.isMultiTenantAuthenticationDisabled()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("The Multi Tenant Authentication is disabled. An updated Tenant Id provided via TokenRequestContext cannot be used in this scenario. To resolve this issue, set the env var AZURE_IDENTITY_DISABLE_MULTITENANTAUTH to false ", null));
            }
            if ("adfs".equals(currentTenantId)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("The credential is configured with`adfs` tenant id and it cannot be replaced with a tenant id challenge provided via TokenRequestContext class. ", null));
            }
            return CoreUtils.isNullOrEmpty((CharSequence)contextTenantId) ? currentTenantId : contextTenantId;
        }
        return currentTenantId;
    }
}

