/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.ValidationUtil;
import reactor.core.publisher.Mono;

public class WorkloadIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredential.class);
    private final IdentityClient identityClient;

    WorkloadIdentityCredential(String tenantId, String clientId, String federatedTokenFilePath, IdentityClientOptions identityClientOptions) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.identityClient = new IdentityClientBuilder().clientAssertionPath(federatedTokenFilePath).clientId(clientId).tenantId(tenantId).identityClientOptions(identityClientOptions).build();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithExchangeToken(request);
    }

    String getClientId() {
        return this.identityClient.getClientId();
    }
}

