/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.iot.deviceupdate.DeviceUpdateClientBuilder;
import com.azure.iot.deviceupdate.implementation.DeviceManagementsImpl;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DeviceUpdateClientBuilder.class, isAsync=true)
public final class DeviceManagementAsyncClient {
    private final DeviceManagementsImpl serviceClient;

    DeviceManagementAsyncClient(DeviceManagementsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return this.serviceClient.listDeviceClassesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassWithResponseAsync(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listInstallableUpdatesForDeviceClass(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.listInstallableUpdatesForDeviceClassAsync(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevices(RequestOptions requestOptions) {
        return this.serviceClient.listDevicesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> importDevicesWithResponse(BinaryData importType, RequestOptions requestOptions) {
        return this.serviceClient.importDevicesWithResponseAsync(importType, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.serviceClient.beginImportDevicesAsync(importType, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceWithResponseAsync(deviceId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceModuleWithResponse(String deviceId, String moduleId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceModuleWithResponseAsync(deviceId, moduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getUpdateComplianceWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceTags(RequestOptions requestOptions) {
        return this.serviceClient.listDeviceTagsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceTagWithResponse(String tagName, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceTagWithResponseAsync(tagName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listGroups(RequestOptions requestOptions) {
        return this.serviceClient.listGroupsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getGroupWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateGroupWithResponse(String groupId, BinaryData group, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateGroupWithResponseAsync(groupId, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.deleteGroupWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupUpdateComplianceWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getGroupUpdateComplianceWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listBestUpdatesForGroupAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentsForGroupAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDeploymentWithResponse(String deploymentId, String groupId, BinaryData deployment, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateDeploymentWithResponseAsync(deploymentId, groupId, deployment, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentStatusWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentStatusWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentDevices(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentDevicesAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> collectLogsWithResponse(String operationId, BinaryData logCollectionRequest, RequestOptions requestOptions) {
        return this.serviceClient.collectLogsWithResponseAsync(operationId, logCollectionRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionOperationWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLogCollectionOperations(RequestOptions requestOptions) {
        return this.serviceClient.listLogCollectionOperationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationDetailedStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionOperationDetailedStatusWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.stopDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> retryDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.retryDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }
}

