/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.iot.deviceupdate.DeviceUpdateClientBuilder;
import com.azure.iot.deviceupdate.implementation.DeviceManagementsImpl;

@ServiceClient(builder=DeviceUpdateClientBuilder.class)
public final class DeviceManagementClient {
    private final DeviceManagementsImpl serviceClient;

    DeviceManagementClient(DeviceManagementsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return this.serviceClient.listDeviceClasses(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassWithResponse(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listInstallableUpdatesForDeviceClass(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.listInstallableUpdatesForDeviceClass(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevices(RequestOptions requestOptions) {
        return this.serviceClient.listDevices(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.serviceClient.beginImportDevices(importType, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceWithResponse(deviceId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceModuleWithResponse(String deviceId, String moduleId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceModuleWithResponse(deviceId, moduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getUpdateComplianceWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceTags(RequestOptions requestOptions) {
        return this.serviceClient.listDeviceTags(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceTagWithResponse(String tagName, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceTagWithResponse(tagName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listGroups(RequestOptions requestOptions) {
        return this.serviceClient.listGroups(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getGroupWithResponse(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateGroupWithResponse(String groupId, BinaryData group, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateGroupWithResponse(groupId, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.deleteGroupWithResponse(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getGroupUpdateComplianceWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getGroupUpdateComplianceWithResponse(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listBestUpdatesForGroup(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentsForGroup(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentWithResponse(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDeploymentWithResponse(String deploymentId, String groupId, BinaryData deployment, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateDeploymentWithResponse(deploymentId, groupId, deployment, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeploymentWithResponse(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentStatusWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentStatusWithResponse(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentDevices(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentDevices(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponse(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> collectLogsWithResponse(String operationId, BinaryData logCollectionRequest, RequestOptions requestOptions) {
        return this.serviceClient.collectLogsWithResponse(operationId, logCollectionRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionOperationWithResponse(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLogCollectionOperations(RequestOptions requestOptions) {
        return this.serviceClient.listLogCollectionOperations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionOperationDetailedStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionOperationDetailedStatusWithResponse(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.stopDeploymentWithResponse(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> retryDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.retryDeploymentWithResponse(groupId, deploymentId, requestOptions);
    }
}

