/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.iot.deviceupdate.DeviceUpdateClientBuilder;
import com.azure.iot.deviceupdate.implementation.DeviceUpdatesImpl;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DeviceUpdateClientBuilder.class, isAsync=true)
public final class DeviceUpdateAsyncClient {
    private final DeviceUpdatesImpl serviceClient;

    DeviceUpdateAsyncClient(DeviceUpdatesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> importUpdateWithResponse(BinaryData updateToImport, RequestOptions requestOptions) {
        return this.serviceClient.importUpdateWithResponseAsync(updateToImport, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportUpdate(BinaryData updateToImport, RequestOptions requestOptions) {
        return this.serviceClient.beginImportUpdateAsync(updateToImport, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listUpdates(RequestOptions requestOptions) {
        return this.serviceClient.listUpdatesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateWithResponse(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getUpdateWithResponseAsync(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteUpdateWithResponse(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.deleteUpdateWithResponseAsync(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginDeleteUpdate(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteUpdateAsync(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listProviders(RequestOptions requestOptions) {
        return this.serviceClient.listProvidersAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNames(String provider, RequestOptions requestOptions) {
        return this.serviceClient.listNamesAsync(provider, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVersions(String provider, String name, RequestOptions requestOptions) {
        return this.serviceClient.listVersionsAsync(provider, name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listFiles(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.listFilesAsync(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileWithResponse(String provider, String name, String version, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileWithResponseAsync(provider, name, version, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponseAsync(operationId, requestOptions);
    }
}

