/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.iot.deviceupdate.DeviceUpdateClientBuilder;
import com.azure.iot.deviceupdate.implementation.DeviceUpdatesImpl;

@ServiceClient(builder=DeviceUpdateClientBuilder.class)
public final class DeviceUpdateClient {
    private final DeviceUpdatesImpl serviceClient;

    DeviceUpdateClient(DeviceUpdatesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportUpdate(BinaryData updateToImport, RequestOptions requestOptions) {
        return this.serviceClient.beginImportUpdate(updateToImport, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listUpdates(RequestOptions requestOptions) {
        return this.serviceClient.listUpdates(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateWithResponse(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getUpdateWithResponse(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginDeleteUpdate(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteUpdate(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listProviders(RequestOptions requestOptions) {
        return this.serviceClient.listProviders(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNames(String provider, RequestOptions requestOptions) {
        return this.serviceClient.listNames(provider, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVersions(String provider, String name, RequestOptions requestOptions) {
        return this.serviceClient.listVersions(provider, name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listFiles(String provider, String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.listFiles(provider, name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String provider, String name, String version, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileWithResponse(provider, name, version, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperations(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponse(operationId, requestOptions);
    }
}

