/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.iot.deviceupdate.DeviceManagementAsyncClient;
import com.azure.iot.deviceupdate.DeviceManagementClient;
import com.azure.iot.deviceupdate.DeviceUpdateAsyncClient;
import com.azure.iot.deviceupdate.DeviceUpdateClient;
import com.azure.iot.deviceupdate.DeviceUpdateServiceVersion;
import com.azure.iot.deviceupdate.implementation.DeviceUpdateClientImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceClientBuilder(serviceClients={DeviceUpdateClient.class, DeviceManagementClient.class, DeviceUpdateAsyncClient.class, DeviceManagementAsyncClient.class})
public final class DeviceUpdateClientBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    static final String[] DEFAULT_SCOPES = new String[]{"https://api.adu.microsoft.com/.default"};
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-iot-deviceupdate.properties");
    private String endpoint;
    private String instanceId;
    private DeviceUpdateServiceVersion serviceVersion;
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;

    public DeviceUpdateClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DeviceUpdateClientBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public DeviceUpdateClientBuilder serviceVersion(DeviceUpdateServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public DeviceUpdateClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public DeviceUpdateClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public DeviceUpdateClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public DeviceUpdateClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public DeviceUpdateClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public DeviceUpdateClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public DeviceUpdateClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public DeviceUpdateClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    private DeviceUpdateClientImpl buildInnerClient() {
        if (this.serviceVersion == null) {
            this.serviceVersion = DeviceUpdateServiceVersion.getLatest();
        }
        if (this.pipeline == null) {
            this.pipeline = this.createHttpPipeline();
        }
        DeviceUpdateClientImpl client = new DeviceUpdateClientImpl(this.pipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, this.instanceId, this.serviceVersion);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        HttpHeaders headers = new HttpHeaders();
        this.clientOptions.getHeaders().forEach(header -> headers.set(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policies.add(new CookiePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).build();
        return httpPipeline;
    }

    public DeviceUpdateAsyncClient buildDeviceUpdateAsyncClient() {
        return new DeviceUpdateAsyncClient(this.buildInnerClient().getDeviceUpdates());
    }

    public DeviceManagementAsyncClient buildDeviceManagementAsyncClient() {
        return new DeviceManagementAsyncClient(this.buildInnerClient().getDeviceManagements());
    }

    public DeviceUpdateClient buildDeviceUpdateClient() {
        return new DeviceUpdateClient(this.buildInnerClient().getDeviceUpdates());
    }

    public DeviceManagementClient buildDeviceManagementClient() {
        return new DeviceManagementClient(this.buildInnerClient().getDeviceManagements());
    }
}

