/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import com.azure.iot.deviceupdate.implementation.DeviceUpdateClientImpl;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DeviceManagementsImpl {
    private final DeviceManagementsService service;
    private final DeviceUpdateClientImpl client;

    DeviceManagementsImpl(DeviceUpdateClientImpl client) {
        this.service = (DeviceManagementsService)RestProxy.create(DeviceManagementsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeviceClasses(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listDeviceClasses(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClassesAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listDeviceClassesSinglePageAsync(requestOptions), nextLink -> this.listDeviceClassesNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClassesAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listDeviceClassesSinglePageAsync(requestOptions, context), nextLink -> this.listDeviceClassesNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return new PagedIterable(this.listDeviceClassesAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassWithResponseAsync(String deviceClassId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDeviceClass(this.client.getEndpoint(), this.client.getInstanceId(), deviceClassId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassWithResponseAsync(String deviceClassId, RequestOptions requestOptions, Context context) {
        return this.service.getDeviceClass(this.client.getEndpoint(), this.client.getInstanceId(), deviceClassId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.getDeviceClassWithResponseAsync(deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassSinglePageAsync(String deviceClassId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listInstallableUpdatesForDeviceClass(this.client.getEndpoint(), this.client.getInstanceId(), deviceClassId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassSinglePageAsync(String deviceClassId, RequestOptions requestOptions, Context context) {
        return this.service.listInstallableUpdatesForDeviceClass(this.client.getEndpoint(), this.client.getInstanceId(), deviceClassId, this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listInstallableUpdatesForDeviceClassAsync(String deviceClassId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listInstallableUpdatesForDeviceClassSinglePageAsync(deviceClassId, requestOptions), nextLink -> this.listInstallableUpdatesForDeviceClassNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listInstallableUpdatesForDeviceClassAsync(String deviceClassId, RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listInstallableUpdatesForDeviceClassSinglePageAsync(deviceClassId, requestOptions, context), nextLink -> this.listInstallableUpdatesForDeviceClassNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listInstallableUpdatesForDeviceClass(String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable(this.listInstallableUpdatesForDeviceClassAsync(deviceClassId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDevices(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listDevices(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevicesAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listDevicesSinglePageAsync(requestOptions), nextLink -> this.listDevicesNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevicesAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listDevicesSinglePageAsync(requestOptions, context), nextLink -> this.listDevicesNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevices(RequestOptions requestOptions) {
        return new PagedIterable(this.listDevicesAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> importDevicesWithResponseAsync(BinaryData importType, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.importDevices(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), importType, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> importDevicesWithResponseAsync(BinaryData importType, RequestOptions requestOptions, Context context) {
        return this.service.importDevices(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), importType, requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportDevicesAsync(BinaryData importType, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.importDevicesWithResponseAsync(importType, requestOptions), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline()), (TypeReference)new TypeReferenceBinaryData(), (TypeReference)new TypeReferenceBinaryData());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportDevicesAsync(BinaryData importType, RequestOptions requestOptions, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.importDevicesWithResponseAsync(importType, requestOptions, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline()), (TypeReference)new TypeReferenceBinaryData(), (TypeReference)new TypeReferenceBinaryData());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.beginImportDevicesAsync(importType, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceWithResponseAsync(String deviceId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDevice(this.client.getEndpoint(), this.client.getInstanceId(), deviceId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceWithResponseAsync(String deviceId, RequestOptions requestOptions, Context context) {
        return this.service.getDevice(this.client.getEndpoint(), this.client.getInstanceId(), deviceId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return (Response)this.getDeviceWithResponseAsync(deviceId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceModuleWithResponseAsync(String deviceId, String moduleId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDeviceModule(this.client.getEndpoint(), this.client.getInstanceId(), deviceId, moduleId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceModuleWithResponseAsync(String deviceId, String moduleId, RequestOptions requestOptions, Context context) {
        return this.service.getDeviceModule(this.client.getEndpoint(), this.client.getInstanceId(), deviceId, moduleId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceModuleWithResponse(String deviceId, String moduleId, RequestOptions requestOptions) {
        return (Response)this.getDeviceModuleWithResponseAsync(deviceId, moduleId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceWithResponseAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getUpdateCompliance(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceWithResponseAsync(RequestOptions requestOptions, Context context) {
        return this.service.getUpdateCompliance(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return (Response)this.getUpdateComplianceWithResponseAsync(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceTagsSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeviceTags(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceTagsSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listDeviceTags(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceTagsAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listDeviceTagsSinglePageAsync(requestOptions), nextLink -> this.listDeviceTagsNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceTagsAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listDeviceTagsSinglePageAsync(requestOptions, context), nextLink -> this.listDeviceTagsNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceTags(RequestOptions requestOptions) {
        return new PagedIterable(this.listDeviceTagsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceTagWithResponseAsync(String tagName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDeviceTag(this.client.getEndpoint(), this.client.getInstanceId(), tagName, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceTagWithResponseAsync(String tagName, RequestOptions requestOptions, Context context) {
        return this.service.getDeviceTag(this.client.getEndpoint(), this.client.getInstanceId(), tagName, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceTagWithResponse(String tagName, RequestOptions requestOptions) {
        return (Response)this.getDeviceTagWithResponseAsync(tagName, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listGroups(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listGroups(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listGroupsAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listGroupsSinglePageAsync(requestOptions), nextLink -> this.listGroupsNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listGroupsAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listGroupsSinglePageAsync(requestOptions, context), nextLink -> this.listGroupsNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listGroups(RequestOptions requestOptions) {
        return new PagedIterable(this.listGroupsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupWithResponseAsync(String groupId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupWithResponseAsync(String groupId, RequestOptions requestOptions, Context context) {
        return this.service.getGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.getGroupWithResponseAsync(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateGroupWithResponseAsync(String groupId, BinaryData group, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.createOrUpdateGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), group, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateGroupWithResponseAsync(String groupId, BinaryData group, RequestOptions requestOptions, Context context) {
        return this.service.createOrUpdateGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), group, requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateGroupWithResponse(String groupId, BinaryData group, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateGroupWithResponseAsync(groupId, group, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponseAsync(String groupId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.deleteGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponseAsync(String groupId, RequestOptions requestOptions, Context context) {
        return this.service.deleteGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.deleteGroupWithResponseAsync(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupUpdateComplianceWithResponseAsync(String groupId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getGroupUpdateCompliance(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupUpdateComplianceWithResponseAsync(String groupId, RequestOptions requestOptions, Context context) {
        return this.service.getGroupUpdateCompliance(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getGroupUpdateComplianceWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.getGroupUpdateComplianceWithResponseAsync(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupSinglePageAsync(String groupId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listBestUpdatesForGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupSinglePageAsync(String groupId, RequestOptions requestOptions, Context context) {
        return this.service.listBestUpdatesForGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listBestUpdatesForGroupAsync(String groupId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listBestUpdatesForGroupSinglePageAsync(groupId, requestOptions), nextLink -> this.listBestUpdatesForGroupNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listBestUpdatesForGroupAsync(String groupId, RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listBestUpdatesForGroupSinglePageAsync(groupId, requestOptions, context), nextLink -> this.listBestUpdatesForGroupNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable(this.listBestUpdatesForGroupAsync(groupId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupSinglePageAsync(String groupId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeploymentsForGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupSinglePageAsync(String groupId, RequestOptions requestOptions, Context context) {
        return this.service.listDeploymentsForGroup(this.client.getEndpoint(), this.client.getInstanceId(), groupId, this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForGroupAsync(String groupId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listDeploymentsForGroupSinglePageAsync(groupId, requestOptions), nextLink -> this.listDeploymentsForGroupNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForGroupAsync(String groupId, RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listDeploymentsForGroupSinglePageAsync(groupId, requestOptions, context), nextLink -> this.listDeploymentsForGroupNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable(this.listDeploymentsForGroupAsync(groupId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.getDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.getDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDeploymentWithResponseAsync(String deploymentId, String groupId, BinaryData deployment, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.createOrUpdateDeployment(this.client.getEndpoint(), this.client.getInstanceId(), deploymentId, groupId, this.client.getServiceVersion().getVersion(), deployment, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDeploymentWithResponseAsync(String deploymentId, String groupId, BinaryData deployment, RequestOptions requestOptions, Context context) {
        return this.service.createOrUpdateDeployment(this.client.getEndpoint(), this.client.getInstanceId(), deploymentId, groupId, this.client.getServiceVersion().getVersion(), deployment, requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDeploymentWithResponse(String deploymentId, String groupId, BinaryData deployment, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateDeploymentWithResponseAsync(deploymentId, groupId, deployment, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.deleteDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.deleteDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.deleteDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentStatusWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getDeploymentStatus(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentStatusWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.getDeploymentStatus(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentStatusWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.getDeploymentStatusWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentDevicesSinglePageAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeploymentDevices(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentDevicesSinglePageAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.listDeploymentDevices(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentDevicesAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listDeploymentDevicesSinglePageAsync(groupId, deploymentId, requestOptions), nextLink -> this.listDeploymentDevicesNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentDevicesAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listDeploymentDevicesSinglePageAsync(groupId, deploymentId, requestOptions, context), nextLink -> this.listDeploymentDevicesNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentDevices(String groupId, String deploymentId, RequestOptions requestOptions) {
        return new PagedIterable(this.listDeploymentDevicesAsync(groupId, deploymentId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponseAsync(String operationId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getOperation(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponseAsync(String operationId, RequestOptions requestOptions, Context context) {
        return this.service.getOperation(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.getOperationWithResponseAsync(operationId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationsSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listOperations(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationsSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listOperations(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationsAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(requestOptions), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationsAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(requestOptions, context), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return new PagedIterable(this.listOperationsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> collectLogsWithResponseAsync(String operationId, BinaryData logCollectionRequest, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.collectLogs(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), logCollectionRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> collectLogsWithResponseAsync(String operationId, BinaryData logCollectionRequest, RequestOptions requestOptions, Context context) {
        return this.service.collectLogs(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), logCollectionRequest, requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> collectLogsWithResponse(String operationId, BinaryData logCollectionRequest, RequestOptions requestOptions) {
        return (Response)this.collectLogsWithResponseAsync(operationId, logCollectionRequest, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationWithResponseAsync(String operationId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getLogCollectionOperation(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationWithResponseAsync(String operationId, RequestOptions requestOptions, Context context) {
        return this.service.getLogCollectionOperation(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.getLogCollectionOperationWithResponseAsync(operationId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionOperationsSinglePageAsync(RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listLogCollectionOperations(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionOperationsSinglePageAsync(RequestOptions requestOptions, Context context) {
        return this.service.listLogCollectionOperations(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLogCollectionOperationsAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listLogCollectionOperationsSinglePageAsync(requestOptions), nextLink -> this.listLogCollectionOperationsNextSinglePageAsync((String)nextLink, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLogCollectionOperationsAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listLogCollectionOperationsSinglePageAsync(requestOptions, context), nextLink -> this.listLogCollectionOperationsNextSinglePageAsync((String)nextLink, null, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLogCollectionOperations(RequestOptions requestOptions) {
        return new PagedIterable(this.listLogCollectionOperationsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationDetailedStatusWithResponseAsync(String operationId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.getLogCollectionOperationDetailedStatus(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionOperationDetailedStatusWithResponseAsync(String operationId, RequestOptions requestOptions, Context context) {
        return this.service.getLogCollectionOperationDetailedStatus(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionOperationDetailedStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.getLogCollectionOperationDetailedStatusWithResponseAsync(operationId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.stopDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.stopDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.stopDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> retryDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.retryDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> retryDeploymentWithResponseAsync(String groupId, String deploymentId, RequestOptions requestOptions, Context context) {
        return this.service.retryDeployment(this.client.getEndpoint(), this.client.getInstanceId(), groupId, deploymentId, this.client.getServiceVersion().getVersion(), requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> retryDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.retryDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeviceClassesNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listDeviceClassesNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listInstallableUpdatesForDeviceClassNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listInstallableUpdatesForDeviceClassNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDevicesNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listDevicesNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceTagsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeviceTagsNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceTagsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listDeviceTagsNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listGroupsNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listGroupsNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listBestUpdatesForGroupNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listBestUpdatesForGroupNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeploymentsForGroupNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listDeploymentsForGroupNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentDevicesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listDeploymentDevicesNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentDevicesNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listDeploymentDevicesNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listOperationsNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionOperationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.service.listLogCollectionOperationsNext(nextLink, this.client.getEndpoint(), requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionOperationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        return this.service.listLogCollectionOperationsNext(nextLink, this.client.getEndpoint(), requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static final class TypeReferenceBinaryData
    extends TypeReference<BinaryData> {
        private TypeReferenceBinaryData() {
        }
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="DeviceUpdateClientDe")
    private static interface DeviceManagementsService {
        @Get(value="/deviceupdate/{instanceId}/management/deviceclasses")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeviceClasses(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Get(value="/deviceupdate/{instanceId}/management/deviceclasses/{deviceClassId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDeviceClass(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="deviceClassId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/deviceclasses/{deviceClassId}/installableupdates")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listInstallableUpdatesForDeviceClass(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="deviceClassId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/devices")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDevices(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Post(value="/deviceupdate/{instanceId}/management/devices")
        @ExpectedResponses(value={202})
        public Mono<Response<Void>> importDevices(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/devices/{deviceId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDevice(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="deviceId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/devices/{deviceId}/modules/{moduleId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDeviceModule(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="deviceId") String var3, @PathParam(value="moduleId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceupdate/{instanceId}/management/updatecompliance")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getUpdateCompliance(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Get(value="/deviceupdate/{instanceId}/management/devicetags")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeviceTags(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Get(value="/deviceupdate/{instanceId}/management/devicetags/{tagName}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDeviceTag(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="tagName") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/groups")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listGroups(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getGroup(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Put(value="/deviceupdate/{instanceId}/management/groups/{groupId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> createOrUpdateGroup(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/deviceupdate/{instanceId}/management/groups/{groupId}")
        @ExpectedResponses(value={204})
        public Mono<Response<Void>> deleteGroup(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/updateCompliance")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getGroupUpdateCompliance(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/bestUpdates")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listBestUpdatesForGroup(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeploymentsForGroup(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDeployment(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Put(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> createOrUpdateDeployment(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="deploymentId") String var3, @PathParam(value="groupId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Delete(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses(value={204})
        public Mono<Response<Void>> deleteDeployment(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}/status")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getDeploymentStatus(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}/devicestates")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeploymentDevices(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceupdate/{instanceId}/management/operations/{operationId}")
        @ExpectedResponses(value={200, 304})
        public Mono<Response<BinaryData>> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/operations")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listOperations(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Put(value="/deviceupdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}")
        @ExpectedResponses(value={201})
        public Mono<Response<BinaryData>> collectLogs(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/deviceupdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getLogCollectionOperation(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceupdate/{instanceId}/management/deviceDiagnostics/logCollections")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listLogCollectionOperations(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, RequestOptions var4, Context var5);

        @Get(value="/deviceupdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}/detailedStatus")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> getLogCollectionOperationDetailedStatus(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, RequestOptions var5, Context var6);

        @Post(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> stopDeployment(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Post(value="/deviceupdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> retryDeployment(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="groupId") String var3, @PathParam(value="deploymentId") String var4, @QueryParam(value="api-version") String var5, RequestOptions var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeviceClassesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listInstallableUpdatesForDeviceClassNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeviceTagsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listGroupsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listBestUpdatesForGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeploymentsForGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listDeploymentDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        public Mono<Response<BinaryData>> listLogCollectionOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, RequestOptions var3, Context var4);
    }
}

