/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class JsonProviderContractTests {
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

    protected abstract JsonProvider getJsonProvider();

    @ParameterizedTest
    @MethodSource(value={"nullJsonSupplier"})
    public void nullJsonThrowsNullPointerException(Method creator) {
        Assertions.assertThrows(NullPointerException.class, () -> PUBLIC_LOOKUP.unreflect(creator).invokeWithArguments(this.getJsonProvider(), null, new JsonOptions()));
    }

    private static Stream<Method> nullJsonSupplier() throws NoSuchMethodException {
        return Stream.of(JsonProvider.class.getDeclaredMethod("createReader", byte[].class, JsonOptions.class), JsonProvider.class.getDeclaredMethod("createReader", String.class, JsonOptions.class), JsonProvider.class.getDeclaredMethod("createReader", InputStream.class, JsonOptions.class), JsonProvider.class.getDeclaredMethod("createReader", Reader.class, JsonOptions.class), JsonProvider.class.getDeclaredMethod("createWriter", OutputStream.class, JsonOptions.class), JsonProvider.class.getDeclaredMethod("createWriter", Writer.class, JsonOptions.class));
    }

    @ParameterizedTest
    @MethodSource(value={"nonNullJsonSupplier"})
    public <T> void nullJsonOptionsThrowsNullPointerException(Method creator, T json) {
        Assertions.assertThrows(NullPointerException.class, () -> PUBLIC_LOOKUP.unreflect(creator).invokeWithArguments(this.getJsonProvider(), json, null));
    }

    @ParameterizedTest
    @MethodSource(value={"nonNullJsonSupplier"})
    public <T> void canCreate(Method creator, T json) {
        Assertions.assertDoesNotThrow(() -> PUBLIC_LOOKUP.unreflect(creator).invokeWithArguments(this.getJsonProvider(), json, new JsonOptions()));
    }

    private static Stream<Arguments> nonNullJsonSupplier() throws NoSuchMethodException {
        return Stream.of(Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createReader", byte[].class, JsonOptions.class), new byte[0]}), Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createReader", String.class, JsonOptions.class), ""}), Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createReader", InputStream.class, JsonOptions.class), new ByteArrayInputStream(new byte[0])}), Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createReader", Reader.class, JsonOptions.class), new StringReader("")}), Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createWriter", OutputStream.class, JsonOptions.class), new ByteArrayOutputStream()}), Arguments.of((Object[])new Object[]{JsonProvider.class.getDeclaredMethod("createWriter", Writer.class, JsonOptions.class), new StringWriter()}));
    }
}

