/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonBoolean;
import com.azure.json.models.JsonElement;
import com.azure.json.models.JsonNull;
import com.azure.json.models.JsonNumber;
import com.azure.json.models.JsonObject;
import com.azure.json.models.JsonString;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonObjectContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonObject element = new JsonObject();
        Assertions.assertTrue((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isBoolean());
        Assertions.assertFalse((boolean)element.isNull());
    }

    @Test
    public void emptyObjectFromJson() throws IOException {
        String json = "{}";
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonObject jsonObject = JsonObject.fromJson((JsonReader)reader);
            Assertions.assertEquals((int)0, (int)jsonObject.size());
        }
    }

    @Test
    public void objectOfBasicTypesFromJson() throws IOException {
        String json = "{\"string\":\"string\",\"null\":null,\"integer\":10,\"float\":10.0,\"boolean\":true}";
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonObject jsonObject = JsonObject.fromJson((JsonReader)reader);
            Assertions.assertEquals((int)5, (int)jsonObject.size());
            JsonElement stringElement = jsonObject.getProperty("string");
            Assertions.assertTrue((boolean)stringElement.isString());
            Assertions.assertEquals((Object)"\"string\"", (Object)stringElement.toJsonString());
            JsonElement nullElement = jsonObject.getProperty("null");
            Assertions.assertTrue((boolean)nullElement.isNull());
            JsonElement intElement = jsonObject.getProperty("integer");
            Assertions.assertTrue((boolean)intElement.isNumber());
            Assertions.assertEquals((Object)"10", (Object)intElement.toJsonString());
            JsonElement doubleElement = jsonObject.getProperty("float");
            Assertions.assertTrue((boolean)doubleElement.isNumber());
            Assertions.assertEquals((Object)"10.0", (Object)doubleElement.toJsonString());
            JsonElement booleanElement = jsonObject.getProperty("boolean");
            Assertions.assertTrue((boolean)booleanElement.isBoolean());
            Assertions.assertEquals((Object)"true", (Object)booleanElement.toJsonString());
            Assertions.assertEquals((Object)json, (Object)jsonObject.toJsonString());
            Assertions.assertEquals((Object)"\"string\"", (Object)jsonObject.removeProperty("string").toJsonString());
            Assertions.assertEquals((int)4, (int)jsonObject.size());
            Assertions.assertNull((Object)jsonObject.removeProperty("string"));
            Assertions.assertEquals((Object)"{\"null\":null,\"integer\":10,\"float\":10.0,\"boolean\":true}", (Object)jsonObject.toJsonString());
        }
    }

    @Test
    public void emptyObjectToJson() throws IOException {
        JsonObject jsonObject = new JsonObject();
        Assertions.assertEquals((int)0, (int)jsonObject.size());
        try (StringBuilderWriter writer = new StringBuilderWriter();
             JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
            jsonObject.toJson(jsonWriter);
            jsonWriter.flush();
            Assertions.assertEquals((Object)"{}", (Object)writer.toString());
        }
    }

    @Test
    public void objectOfBasicTypesToJson() throws IOException {
        JsonObject jsonObject = new JsonObject().setProperty("string", (JsonElement)new JsonString("string")).setProperty("null", (JsonElement)JsonNull.getInstance()).setProperty("integer", (JsonElement)new JsonNumber((Number)10)).setProperty("float", (JsonElement)new JsonNumber((Number)10.0)).setProperty("boolean", (JsonElement)JsonBoolean.getInstance((boolean)true));
        Assertions.assertEquals((int)5, (int)jsonObject.size());
        try (StringBuilderWriter writer = new StringBuilderWriter();
             JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
            jsonObject.toJson(jsonWriter);
            jsonWriter.flush();
            Assertions.assertEquals((Object)"{\"string\":\"string\",\"null\":null,\"integer\":10,\"float\":10.0,\"boolean\":true}", (Object)writer.toString());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "null", "1", "1.0", "\"hello\"", "[]"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonObject.fromJson((JsonReader)reader));
        }
    }
}

