/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation;

import com.azure.json.implementation.StringBuilderWriter;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class StringBuilderWriterTests {
    @Test
    public void nullStringBuilderThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new StringBuilderWriter(null));
    }

    @ParameterizedTest
    @MethodSource(value={"canWriteToNewInstanceSupplier"})
    public void canWriteToNewInstance(Callable<StringBuilderWriter> writeOperation, String expected) throws Exception {
        StringBuilderWriter writer = writeOperation.call();
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    private static Stream<Arguments> canWriteToNewInstanceSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.write(97);
            return writer;
        }, "a"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.write(new char[]{'a', 'b', 'c'});
            return writer;
        }, "abc"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.write("abc");
            return writer;
        }, "abc"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.write("abc", 1, 2);
            return writer;
        }, "b"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.append((CharSequence)"abc");
            return writer;
        }, "abc"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.append((CharSequence)"abc", 1, 2);
            return writer;
        }, "b"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.append('a');
            return writer;
        }, "a"}), Arguments.of((Object[])new Object[]{() -> {
            StringBuilderWriter writer = new StringBuilderWriter();
            writer.write(new char[]{'a', 'b', 'c'}, 1, 1);
            return writer;
        }, "b"}));
    }

    @ParameterizedTest
    @MethodSource(value={"writingAfterCloseThrowsSupplier"})
    public void writingAfterCloseThrows(Callable<StringBuilderWriter> writeOperation) {
        Assertions.assertThrows(IOException.class, writeOperation::call);
    }

    private static Stream<Callable<StringBuilderWriter>> writingAfterCloseThrowsSupplier() {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.close();
        return Stream.of(() -> {
            writer.write(97);
            return writer;
        }, () -> {
            writer.write(new char[]{'a', 'b', 'c'});
            return writer;
        }, () -> {
            writer.write("abc");
            return writer;
        }, () -> {
            writer.write("abc", 1, 2);
            return writer;
        }, () -> {
            writer.append((CharSequence)"abc");
            return writer;
        }, () -> {
            writer.append((CharSequence)"abc", 1, 2);
            return writer;
        }, () -> {
            writer.append('a');
            return writer;
        }, () -> {
            writer.write(new char[]{'a', 'b', 'c'}, 1, 1);
            return writer;
        }, () -> {
            writer.flush();
            return writer;
        });
    }
}

