/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract;

import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriteState;
import com.azure.json.JsonWriter;
import com.azure.json.contract.SimpleSerializable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class JsonWriterContractTests {
    public abstract JsonWriter getJsonWriter();

    public abstract String getJsonWriterContents();

    @ParameterizedTest
    @MethodSource(value={"basicOperationsSupplier"})
    public void basicOperations(IOExceptionConsumer<JsonWriter> operation, String expectedJson) throws IOException {
        this.writeAndValidate(operation, expectedJson);
    }

    private static Stream<Arguments> basicOperationsSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeStartObject), "{"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeEndObject()), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeStartArray), "["}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeEndArray()), "[]"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeString("value").writeEndObject()), "{\"fieldName\":\"value\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBinary(null)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBinary(new byte[0])), "\"\""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBinary("Hello".getBytes(StandardCharsets.UTF_8))), "\"" + Base64.getEncoder().encodeToString("Hello".getBytes(StandardCharsets.UTF_8)) + "\""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBoolean(true)), "true"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBoolean(false)), "false"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBoolean(null)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBoolean(Boolean.TRUE)), "true"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDouble(-42.0)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDouble(-42.0)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDouble(42.0)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDouble(42.0)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloat(-42.0f)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloat(-42.0f)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloat(42.0f)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloat(42.0f)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(42)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(-42)), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeLong(42L)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeLong(-42L)), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeNull), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber(null)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)-42.0)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)-42.0)), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42.0)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42.0)), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)Float.valueOf(-42.0f))), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)Float.valueOf(-42.0f))), "-42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)Float.valueOf(42.0f))), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)Float.valueOf(42.0f))), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)-42)), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42L)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)-42L)), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)42)), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)new AtomicInteger(-42))), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)new AtomicInteger(42))), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)new AtomicLong(-42L))), "-42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumber((Number)new AtomicLong(42L))), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeString(null)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeString("")), "\"\""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeString("null")), "\"null\""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("\"string\"")), "\"string\""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("42")), "42"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("42.0")), "42.0"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("true")), "true"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("false")), "false"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("null")), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("[]")), "[]"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("[null]")), "[null]"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("{}")), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("{null}")), "{null}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBinaryField("field", null)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBinaryField("field", new byte[0])), "{\"field\":\"\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBinaryField("field", "Hello".getBytes(StandardCharsets.UTF_8))), "{\"field\":\"" + Base64.getEncoder().encodeToString("Hello".getBytes(StandardCharsets.UTF_8)) + "\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBooleanField("field", true)), "{\"field\":true}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBooleanField("field", false)), "{\"field\":false}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBooleanField("field", null)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeBooleanField("field", Boolean.TRUE)), "{\"field\":true}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeDoubleField("field", -42.0)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeDoubleField("field", -42.0)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeDoubleField("field", 42.0)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeDoubleField("field", 42.0)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeFloatField("field", -42.0f)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeFloatField("field", -42.0f)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeFloatField("field", 42.0f)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeFloatField("field", 42.0f)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeIntField("field", 42)), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeIntField("field", -42)), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeLongField("field", 42L)), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeLongField("field", -42L)), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNullField("field")), "{\"field\":null}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", null)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)-42.0)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)-42.0)), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)42.0)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)42.0)), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)Float.valueOf(-42.0f))), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)Float.valueOf(-42.0f))), "{\"field\":-42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)Float.valueOf(42.0f))), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)Float.valueOf(42.0f))), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)42)), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)-42)), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)42L)), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)-42L)), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)new AtomicInteger(42))), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)new AtomicInteger(-42))), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)new AtomicLong(42L))), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeNumberField("field", (Number)new AtomicLong(-42L))), "{\"field\":-42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeStringField("field", null)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeStringField("field", "")), "{\"field\":\"\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeStringField("field", "null")), "{\"field\":\"null\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "\"string\"")), "{\"field\":\"string\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "42")), "{\"field\":42}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "42.0")), "{\"field\":42.0}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "true")), "{\"field\":true}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "false")), "{\"field\":false}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "null")), "{\"field\":null}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "[]")), "{\"field\":[]}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "[null]")), "{\"field\":[null]}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "{}")), "{\"field\":{}}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(jsonWriter -> jsonWriter.writeRawField("field", "{null}")), "{\"field\":{null}}"}));
    }

    @ParameterizedTest
    @MethodSource(value={"basicExceptionsSupplier"})
    public void basicExceptions(IOExceptionConsumer<JsonWriter> operation, Class<? extends Throwable> expectedException) {
        Assertions.assertThrows(expectedException, () -> operation.accept(this.getJsonWriter()));
    }

    private static Stream<Arguments> basicExceptionsSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeEndArray), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeEndObject), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFieldName("fieldName")), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStringField("fieldName", "fieldValue")), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeStartArray()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeEndArray()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeInt(0)), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeEndObject()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeFieldName("fieldName")), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeIntField("fieldName", 0)), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeEndArray()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeEndObject()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeFieldName("anotherFieldName")), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeIntField("anotherFieldName", 0)), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeStartArray()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeEndArray()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeStartObject()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeEndObject()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeFieldName("fieldName")), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeInt(0)), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0).writeIntField("fieldName", 0)), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().close()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().close()), IllegalStateException.class}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").close()), IllegalStateException.class}));
    }

    @ParameterizedTest
    @MethodSource(value={"basicWriteStateSupplier"})
    public void basicWriteState(IOExceptionConsumer<JsonWriter> operation, JsonWriteState expectedState) {
        JsonWriter writer = this.getJsonWriter();
        Assertions.assertDoesNotThrow(() -> operation.accept(writer));
        Assertions.assertEquals((Object)expectedState, (Object)writer.getWriteContext().getWriteState());
    }

    private static Stream<Arguments> basicWriteStateSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> {}), JsonWriteState.ROOT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeStartObject), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeStartArray), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBinary(null)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBoolean(true)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDouble(0.0)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloat(0.0f)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeInt(0)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeLong(0L)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(JsonWriter::writeNull), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeString(null)), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue("\"\"")), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeBinary(null)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeBoolean(true)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeDouble(0.0)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeFloat(0.0f)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeInt(0)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeLong(0L)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeNull()), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeString(null)), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeRawValue("\"\"")), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeEndObject()), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeEndArray()), JsonWriteState.COMPLETED}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeStartObject()), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeStartArray()), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray().writeStartArray().writeEndArray()), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName")), JsonWriteState.FIELD}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeBinaryField("fieldName", null)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeBooleanField("fieldName", true)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeDoubleField("fieldName", 0.0)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFloatField("fieldName", 0.0f)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeIntField("fieldName", 0)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeLongField("fieldName", 0L)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeNullField("fieldName")), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeStringField("fieldName", null)), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeRawField("fieldName", "\"\"")), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeStartObject()), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeStartArray()), JsonWriteState.ARRAY}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeStartObject().writeEndObject()), JsonWriteState.OBJECT}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject().writeFieldName("fieldName").writeStartArray().writeEndArray()), JsonWriteState.OBJECT}));
    }

    @ParameterizedTest
    @MethodSource(value={"nullPointerExceptionsSupplier"})
    public void nullPointerExceptions(IOExceptionConsumer<JsonWriter> consumer) {
        Assertions.assertThrows(NullPointerException.class, () -> consumer.accept(this.getJsonWriter()));
    }

    private static Stream<IOExceptionConsumer<JsonWriter>> nullPointerExceptionsSupplier() {
        return Stream.of(JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartObject(null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStartArray(null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFieldName(null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArray((Object[])null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArray(Collections.emptyList(), null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeMap(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawValue(null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNullableField(null, null, JsonWriter::writeUntyped)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNullableField("field", null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeJsonField(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArrayField(null, (Object[])null, JsonWriter::writeUntyped)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArrayField("field", (Object[])null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArrayField(null, Collections.emptyList(), JsonWriter::writeUntyped)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeArrayField("field", (Iterable)null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeMapField(null, null, JsonWriter::writeUntyped)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeMapField("field", null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBinaryField(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBooleanField(null, false)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeBooleanField(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeDoubleField(null, 0.0)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeFloatField(null, 0.0f)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeIntField(null, 0)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeLongField(null, 0L)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNullField(null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeNumberField(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeStringField(null, null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawField(null, "0")), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeRawField("field", null)), JsonWriterContractTests.write(jsonWriter -> jsonWriter.writeUntypedField(null, null)));
    }

    @Test
    public void writeStartObjectNullFieldName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeStartObject(null));
    }

    @Test
    public void writeStartObjectWithFieldName() throws IOException {
        this.writeAndValidate(JsonWriterContractTests.writeField(writer -> writer.writeStartObject("objectWithFieldName").writeEndObject()), "{\"objectWithFieldName\":{}}");
    }

    @Test
    public void writeStartArrayNullFieldName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeStartArray(null));
    }

    @Test
    public void writeStartArrayWithFieldName() throws IOException {
        this.writeAndValidate(JsonWriterContractTests.writeField(writer -> writer.writeStartArray("arrayWithFieldName").writeEndArray()), "{\"arrayWithFieldName\":[]}");
    }

    @Test
    public void writeJsonFieldNullFieldNameThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeJsonField(null, null));
    }

    @ParameterizedTest
    @MethodSource(value={"writeJsonSupplier"})
    public void writeJson(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> writeJsonSupplier() {
        SimpleSerializable serializable = new SimpleSerializable(true, 42, 42.0, "hello");
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeJson(null)), ""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeJson((JsonSerializable)serializable)), "{\"boolean\":true,\"int\":42,\"decimal\":42.0,\"string\":\"hello\"}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeJsonField("field", null)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeJsonField("field", (JsonSerializable)serializable)), "{\"field\":{\"boolean\":true,\"int\":42,\"decimal\":42.0,\"string\":\"hello\"}}"}));
    }

    @Test
    public void writeArrayThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArray(new Object[0], null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArray(Collections.emptyList(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArrayField(null, new Object[0], null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArrayField(null, Collections.emptyList(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArrayField("field", new Object[0], null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeArrayField("field", Collections.emptyList(), null));
    }

    @ParameterizedTest
    @MethodSource(value={"writeArraySupplier"})
    public void writeArray(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> writeArraySupplier() {
        Object[] array = new Object[]{true, 42, 42.0, "hello"};
        String expected = "[true,42,42.0,\"hello\"]";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Object[])null, JsonWriter::writeUntyped)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray(new Object[0], JsonWriter::writeUntyped)), "[]"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray(array, JsonWriter::writeUntyped)), expected}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Iterable)null, JsonWriter::writeUntyped)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray(Collections.emptyList(), JsonWriter::writeUntyped)), "[]"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray(Arrays.asList(array), JsonWriter::writeUntyped)), expected}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArrayField("field", (Object[])null, JsonWriter::writeUntyped)), ""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", new Object[0], JsonWriter::writeUntyped)), "{\"field\":[]}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", array, JsonWriter::writeUntyped)), "{\"field\":" + expected + "}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArrayField("field", (Iterable)null, JsonWriter::writeUntyped)), ""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", Collections.emptyList(), JsonWriter::writeUntyped)), "{\"field\":[]}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArray(Arrays.asList(array), JsonWriter::writeUntyped)), "{\"field\":" + expected + "}"}));
    }

    @Test
    public void writeMapThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeMap(Collections.emptyMap(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeMapField(null, Collections.emptyMap(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeMapField("field", Collections.emptyMap(), null));
    }

    @ParameterizedTest
    @MethodSource(value={"writeMapSupplier"})
    public void writeMap(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> writeMapSupplier() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("boolean", true);
        map.put("int", 42);
        map.put("decimal", 42.0);
        map.put("string", "hello");
        String expected = "{\"boolean\":true,\"int\":42,\"decimal\":42.0,\"string\":\"hello\"}";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(null, JsonWriter::writeUntyped)), "null"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(Collections.emptyMap(), JsonWriter::writeUntyped)), "{}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(map, JsonWriter::writeUntyped)), expected}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMapField("field", null, JsonWriter::writeUntyped)), ""}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeMapField("field", Collections.emptyMap(), JsonWriter::writeUntyped)), "{\"field\":{}}"}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeMapField("field", map, JsonWriter::writeUntyped)), "{\"field\":" + expected + "}"}));
    }

    @ParameterizedTest
    @MethodSource(value={"writeUntypedSupplier"})
    public void writeUntyped(Object value, String expectedJson) throws IOException {
        this.writeAndValidate(writer -> writer.writeUntyped(value), expectedJson);
    }

    @ParameterizedTest
    @MethodSource(value={"writeUntypedSupplier"})
    public void writeUntypedField(Object value, String expectedUntypedJson) throws IOException {
        this.writeAndValidate(JsonWriterContractTests.writeField(writer -> writer.writeUntypedField("untyped", value)), "{\"untyped\":" + expectedUntypedJson + "}");
    }

    private static Stream<Arguments> writeUntypedSupplier() {
        byte[] bytes = new byte[]{0, 1, 2, 3};
        UUID uuid = UUID.randomUUID();
        return Stream.of(Arguments.of((Object[])new Object[]{null, "null"}), Arguments.of((Object[])new Object[]{(short)42, "42"}), Arguments.of((Object[])new Object[]{42, "42"}), Arguments.of((Object[])new Object[]{42L, "42"}), Arguments.of((Object[])new Object[]{Float.valueOf(42.0f), "42.0"}), Arguments.of((Object[])new Object[]{42.0, "42.0"}), Arguments.of((Object[])new Object[]{true, "true"}), Arguments.of((Object[])new Object[]{bytes, "\"" + Base64.getEncoder().encodeToString(bytes) + "\""}), Arguments.of((Object[])new Object[]{"hello", "\"hello\""}), Arguments.of((Object[])new Object[]{Character.valueOf('h'), "\"h\""}), Arguments.of((Object[])new Object[]{new SimpleSerializable(true, 42, 42.0, "hello"), "{\"boolean\":true,\"int\":42,\"decimal\":42.0,\"string\":\"hello\"}"}), Arguments.of((Object[])new Object[]{new Object[0], "[]"}), Arguments.of((Object[])new Object[]{new Object[]{null, 42, 42.0, true, "hello", Character.valueOf('h')}, "[null,42,42.0,true,\"hello\",\"h\"]"}), Arguments.of((Object[])new Object[]{Collections.emptyList(), "[]"}), Arguments.of((Object[])new Object[]{Arrays.asList(null, 42, 42.0, true, "hello", Character.valueOf('h')), "[null,42,42.0,true,\"hello\",\"h\"]"}), Arguments.of((Object[])new Object[]{Collections.singletonMap("hello", "json"), "{\"hello\":\"json\"}"}), Arguments.of((Object[])new Object[]{new Object(), "{}"}), Arguments.of((Object[])new Object[]{uuid, "\"" + uuid + "\""}));
    }

    @Test
    public void writeNullableNullWriterFuncThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getJsonWriter().writeNullableField("field", null, null));
    }

    @Test
    public void writeNullableFieldNullValueWritesJsonNull() throws IOException {
        this.writeAndValidate(JsonWriterContractTests.writeField(writer -> writer.writeNullableField("field", null, JsonWriter::writeUntyped)), "{\"field\":null}");
    }

    @Test
    public void writeNullableFieldNonNullValueWritesJsonField() throws IOException {
        this.writeAndValidate(writer -> writer.writeStartObject().writeNullableField("field", (Object)"hello", JsonWriter::writeString).writeEndObject(), "{\"field\":\"hello\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"arrayMethodsWriteNullValueSupplier"})
    public void arrayMethodsWriteNullValue(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> arrayMethodsWriteNullValueSupplier() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("hello");
        list.add(null);
        list.add("world");
        String[] array = new String[]{"hello", null, "world"};
        String expectedJson = "[\"hello\",null,\"world\"]";
        String expectedFieldJson = "{\"field\":" + expectedJson + "}";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Iterable)list, JsonWriter::writeString)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Iterable)list, JsonWriter::writeString, false)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Object[])array, JsonWriter::writeString)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Object[])array, JsonWriter::writeString, false)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Iterable)list, JsonWriter::writeString)), expectedFieldJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Iterable)list, JsonWriter::writeString, false)), expectedFieldJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Object[])array, JsonWriter::writeString)), expectedFieldJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Object[])array, JsonWriter::writeString, false)), expectedFieldJson}));
    }

    @ParameterizedTest
    @MethodSource(value={"arrayMethodsSkipNullValueSupplier"})
    public void arrayMethodsSkipNullValue(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> arrayMethodsSkipNullValueSupplier() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("hello");
        list.add(null);
        list.add("world");
        String[] array = new String[]{"hello", null, "world"};
        String expectedJson = "[\"hello\",\"world\"]";
        String expectedFieldJson = "{\"field\":" + expectedJson + "}";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Iterable)list, JsonWriter::writeString, true)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeArray((Object[])array, JsonWriter::writeString, true)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Iterable)list, JsonWriter::writeString, true)), expectedFieldJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeArrayField("field", (Object[])array, JsonWriter::writeString, true)), expectedFieldJson}));
    }

    @ParameterizedTest
    @MethodSource(value={"mapMethodsWriteNullValueSupplier"})
    public void mapMethodsWriteNullValue(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> mapMethodsWriteNullValueSupplier() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hello", "world");
        map.put("null", null);
        String expectedJson = "{\"hello\":\"world\",\"null\":null}";
        String expectedFieldJson = "{\"field\":" + expectedJson + "}";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(map, JsonWriter::writeString)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(map, JsonWriter::writeString, false)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeMapField("field", map, JsonWriter::writeString)), expectedFieldJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeMapField("field", map, JsonWriter::writeString, false)), expectedFieldJson}));
    }

    @ParameterizedTest
    @MethodSource(value={"mapMethodsSkipNullValueSupplier"})
    public void mapMethodsSkipNullValue(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        this.writeAndValidate(write, expected);
    }

    private static Stream<Arguments> mapMethodsSkipNullValueSupplier() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hello", "world");
        map.put("null", null);
        String expectedJson = "{\"hello\":\"world\"}";
        String expectedFieldJson = "{\"field\":" + expectedJson + "}";
        return Stream.of(Arguments.of((Object[])new Object[]{JsonWriterContractTests.write(writer -> writer.writeMap(map, JsonWriter::writeString, true)), expectedJson}), Arguments.of((Object[])new Object[]{JsonWriterContractTests.writeField(writer -> writer.writeMapField("field", map, JsonWriter::writeString, true)), expectedFieldJson}));
    }

    private void writeAndValidate(IOExceptionConsumer<JsonWriter> write, String expected) throws IOException {
        try (JsonWriter writer = this.getJsonWriter();){
            write.accept(writer);
            writer.flush();
            Assertions.assertEquals((Object)expected, (Object)this.getJsonWriterContents());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static IOExceptionConsumer<JsonWriter> write(IOExceptionConsumer<JsonWriter> callback) {
        return callback;
    }

    private static IOExceptionConsumer<JsonWriter> writeField(IOExceptionConsumer<JsonWriter> callback) {
        return writer -> {
            writer.writeStartObject();
            callback.accept((JsonWriter)writer);
            writer.writeEndObject();
        };
    }

    public static interface IOExceptionConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

