/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonArray;
import com.azure.json.models.JsonBoolean;
import com.azure.json.models.JsonElement;
import com.azure.json.models.JsonNull;
import com.azure.json.models.JsonNumber;
import com.azure.json.models.JsonString;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonArrayContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonArray element = new JsonArray();
        Assertions.assertTrue((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isBoolean());
        Assertions.assertFalse((boolean)element.isNull());
    }

    @Test
    public void emptyArrayFromJson() throws IOException {
        String json = "[]";
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonArray jsonArray = JsonArray.fromJson((JsonReader)reader);
            Assertions.assertEquals((int)0, (int)jsonArray.size());
        }
    }

    @Test
    public void arrayOfBasicTypesFromJson() throws IOException {
        String json = "[\"string\",null,10,10.0,true]";
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonArray jsonArray = JsonArray.fromJson((JsonReader)reader);
            JsonElement stringElement = jsonArray.getElement(0);
            Assertions.assertTrue((boolean)stringElement.isString());
            Assertions.assertEquals((Object)"\"string\"", (Object)stringElement.toJsonString());
            JsonElement nullElement = jsonArray.getElement(1);
            Assertions.assertTrue((boolean)nullElement.isNull());
            JsonElement intElement = jsonArray.getElement(2);
            Assertions.assertTrue((boolean)intElement.isNumber());
            Assertions.assertEquals((Object)"10", (Object)intElement.toJsonString());
            JsonElement doubleElement = jsonArray.getElement(3);
            Assertions.assertTrue((boolean)doubleElement.isNumber());
            Assertions.assertEquals((Object)"10.0", (Object)doubleElement.toJsonString());
            JsonElement booleanElement = jsonArray.getElement(4);
            Assertions.assertTrue((boolean)booleanElement.isBoolean());
            Assertions.assertEquals((Object)"true", (Object)booleanElement.toJsonString());
        }
    }

    @Test
    public void emptyArrayToJson() throws IOException {
        JsonArray jsonArray = new JsonArray();
        Assertions.assertEquals((int)0, (int)jsonArray.size());
        try (StringBuilderWriter writer = new StringBuilderWriter();
             JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
            jsonArray.toJson(jsonWriter);
            jsonWriter.flush();
            Assertions.assertEquals((Object)"[]", (Object)writer.toString());
        }
    }

    @Test
    public void arrayOfBasicTypesToJson() throws IOException {
        JsonArray jsonArray = new JsonArray().addElement((JsonElement)new JsonString("string")).addElement((JsonElement)JsonNull.getInstance()).addElement((JsonElement)new JsonNumber((Number)10)).addElement((JsonElement)new JsonNumber((Number)10.0)).addElement((JsonElement)JsonBoolean.getInstance((boolean)true));
        Assertions.assertEquals((int)5, (int)jsonArray.size());
        try (StringBuilderWriter writer = new StringBuilderWriter();
             JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
            jsonArray.toJson(jsonWriter);
            jsonWriter.flush();
            Assertions.assertEquals((Object)"[\"string\",null,10,10.0,true]", (Object)writer.toString());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "null", "10", "10.0", "\"hello\"", "{}"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonArray.fromJson((JsonReader)reader));
        }
    }
}

