/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonBoolean;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonBooleanContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonBoolean element = JsonBoolean.getInstance((boolean)true);
        Assertions.assertTrue((boolean)element.isBoolean());
        Assertions.assertFalse((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isNull());
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    public void fromJson(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonBoolean jsonBoolean = JsonBoolean.fromJson((JsonReader)reader);
            Assertions.assertEquals((Object)json, (Object)jsonBoolean.toJsonString());
            if ("true".equals(json)) {
                Assertions.assertTrue((boolean)jsonBoolean.getValue());
                Assertions.assertSame((Object)JsonBoolean.getInstance((boolean)true), (Object)jsonBoolean);
            } else {
                Assertions.assertFalse((boolean)jsonBoolean.getValue());
                Assertions.assertSame((Object)JsonBoolean.getInstance((boolean)false), (Object)jsonBoolean);
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void toJson(boolean value) throws IOException {
        JsonBoolean jsonBoolean = JsonBoolean.getInstance((boolean)value);
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            try (JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
                jsonBoolean.toJson(jsonWriter);
            }
            Assertions.assertEquals((Object)Boolean.toString(value), (Object)writer.toString());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"null", "10", "10.0", "\"hello\"", "[]", "{}"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonBoolean.fromJson((JsonReader)reader));
        }
    }
}

