/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonNull;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonNullContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonNull element = JsonNull.getInstance();
        Assertions.assertTrue((boolean)element.isNull());
        Assertions.assertFalse((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isBoolean());
    }

    @Test
    public void fromJson() throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader("null", new JsonOptions());){
            JsonNull jsonNull = JsonNull.fromJson((JsonReader)reader);
            Assertions.assertEquals((Object)"null", (Object)jsonNull.toJsonString());
            Assertions.assertSame((Object)JsonNull.getInstance(), (Object)jsonNull);
        }
    }

    @Test
    public void toJson() throws IOException {
        JsonNull jsonNull = JsonNull.getInstance();
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            try (JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
                jsonNull.toJson(jsonWriter);
            }
            Assertions.assertEquals((Object)"null", (Object)writer.toString());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "10", "10.0", "\"hello\"", "[]", "{}"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonNull.fromJson((JsonReader)reader));
        }
    }
}

