/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonNumber;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonNumberContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonNumber element = new JsonNumber((Number)0);
        Assertions.assertTrue((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isBoolean());
        Assertions.assertFalse((boolean)element.isNull());
    }

    @ParameterizedTest
    @MethodSource(value={"fromJsonSupplier"})
    public void fromJson(String json, Number number) throws IOException, ParseException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonNumber jsonNumber = JsonNumber.fromJson((JsonReader)reader);
            if (number instanceof BigInteger) {
                BigInteger jsonBigInteger = (BigInteger)Assertions.assertInstanceOf(BigInteger.class, (Object)jsonNumber.getValue());
                Assertions.assertEquals((int)0, (int)((BigInteger)number).compareTo(jsonBigInteger));
            } else if (number instanceof BigDecimal) {
                BigDecimal jsonBigDecimal = (BigDecimal)Assertions.assertInstanceOf(BigDecimal.class, (Object)jsonNumber.getValue());
                Assertions.assertEquals((int)0, (int)((BigDecimal)number).compareTo(jsonBigDecimal));
            } else {
                Assertions.assertEquals((Object)number, (Object)jsonNumber.getValue());
            }
        }
    }

    private static Stream<Arguments> fromJsonSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"0", 0}), Arguments.of((Object[])new Object[]{"-1", -1}), Arguments.of((Object[])new Object[]{"10000000000", 10000000000L}), Arguments.of((Object[])new Object[]{"-10000000000", -10000000000L}), Arguments.of((Object[])new Object[]{"100000000000000000000", new BigInteger("100000000000000000000")}), Arguments.of((Object[])new Object[]{"-100000000000000000000", new BigInteger("-100000000000000000000")}), Arguments.of((Object[])new Object[]{"0.0", Float.valueOf(0.0f)}), Arguments.of((Object[])new Object[]{"-1.0", Float.valueOf(-1.0f)}), Arguments.of((Object[])new Object[]{"1E6", Float.valueOf(1000000.0f)}), Arguments.of((Object[])new Object[]{"-1E6", Float.valueOf(-1000000.0f)}), Arguments.of((Object[])new Object[]{"1.0E6", Float.valueOf(1000000.0f)}), Arguments.of((Object[])new Object[]{"-1.0E6", Float.valueOf(-1000000.0f)}), Arguments.of((Object[])new Object[]{"1e6", Float.valueOf(1000000.0f)}), Arguments.of((Object[])new Object[]{"-1e6", Float.valueOf(-1000000.0f)}), Arguments.of((Object[])new Object[]{"1.0e6", Float.valueOf(1000000.0f)}), Arguments.of((Object[])new Object[]{"-1.0e6", Float.valueOf(-1000000.0f)}), Arguments.of((Object[])new Object[]{"1E39", 1.0E39}), Arguments.of((Object[])new Object[]{"-1E39", -1.0E39}), Arguments.of((Object[])new Object[]{"1.0E39", 1.0E39}), Arguments.of((Object[])new Object[]{"-1.0E39", -1.0E39}), Arguments.of((Object[])new Object[]{"1e39", 1.0E39}), Arguments.of((Object[])new Object[]{"-1e39", -1.0E39}), Arguments.of((Object[])new Object[]{"1.0e39", 1.0E39}), Arguments.of((Object[])new Object[]{"-1.0e39", -1.0E39}), Arguments.of((Object[])new Object[]{"1E309", new BigDecimal("1E309")}), Arguments.of((Object[])new Object[]{"-1E309", new BigDecimal("-1E309")}), Arguments.of((Object[])new Object[]{"1.0E309", new BigDecimal("1E309")}), Arguments.of((Object[])new Object[]{"-1.0E309", new BigDecimal("-1E309")}), Arguments.of((Object[])new Object[]{"1e309", new BigDecimal("1E309")}), Arguments.of((Object[])new Object[]{"-1e309", new BigDecimal("-1E309")}), Arguments.of((Object[])new Object[]{"1.0e309", new BigDecimal("1E309")}), Arguments.of((Object[])new Object[]{"-1.0e309", new BigDecimal("-1E309")}), Arguments.of((Object[])new Object[]{"Infinity", Double.POSITIVE_INFINITY}), Arguments.of((Object[])new Object[]{"-Infinity", Double.NEGATIVE_INFINITY}));
    }

    @ParameterizedTest
    @MethodSource(value={"toJsonSupplier"})
    public void toJson(Number value) throws IOException {
        JsonNumber jsonNumber = new JsonNumber(value);
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            try (JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
                jsonNumber.toJson(jsonWriter);
            }
            Assertions.assertEquals((Object)String.valueOf(value), (Object)writer.toString());
        }
    }

    private static Stream<Number> toJsonSupplier() {
        return Stream.of(0, -1, 0.0, -1.0, 1000000.0, -1000000.0, 1000000.0, -1000000.0);
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "null", "\"hello\"", "[]", "{}"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonNumber.fromJson((JsonReader)reader));
        }
    }
}

