/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract.models;

import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonWriter;
import com.azure.json.implementation.StringBuilderWriter;
import com.azure.json.models.JsonString;
import java.io.IOException;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class JsonStringContractTests {
    protected abstract JsonProvider getJsonProvider();

    @Test
    public void kindCheck() {
        JsonString element = new JsonString("");
        Assertions.assertTrue((boolean)element.isString());
        Assertions.assertFalse((boolean)element.isArray());
        Assertions.assertFalse((boolean)element.isObject());
        Assertions.assertFalse((boolean)element.isNumber());
        Assertions.assertFalse((boolean)element.isBoolean());
        Assertions.assertFalse((boolean)element.isNull());
    }

    @ParameterizedTest
    @ValueSource(strings={"\"\"", "\"hello\""})
    public void fromJson(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            JsonString jsonString = JsonString.fromJson((JsonReader)reader);
            Assertions.assertEquals((Object)json, (Object)jsonString.toJsonString());
            Assertions.assertEquals((Object)json.substring(1, json.length() - 1), (Object)jsonString.getValue());
        }
    }

    @Test
    public void toJsonStringCachesValue() throws IOException {
        JsonString jsonString = new JsonString("hello");
        String json = jsonString.toJsonString();
        Assertions.assertEquals((Object)"\"hello\"", (Object)json);
        Assertions.assertSame((Object)json, (Object)jsonString.toJsonString());
    }

    @ParameterizedTest
    @ValueSource(strings={"", "hello"})
    public void toJson(String value) throws IOException {
        JsonString jsonString = new JsonString(value);
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            try (JsonWriter jsonWriter = this.getJsonProvider().createWriter((Writer)writer, new JsonOptions());){
                jsonString.toJson(jsonWriter);
            }
            Assertions.assertEquals((Object)("\"" + value + "\""), (Object)writer.toString());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "null", "1", "1.0", "[]", "{}"})
    public void invalidFromJsonStartingPoints(String json) throws IOException {
        try (JsonReader reader = this.getJsonProvider().createReader(json, new JsonOptions());){
            Assertions.assertThrows(IllegalStateException.class, () -> JsonString.fromJson((JsonReader)reader));
        }
    }
}

