/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation;

import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.azure.json.contract.JsonReaderContractTests;
import com.azure.json.implementation.DefaultJsonReader;
import com.azure.json.implementation.jackson.core.JsonParseException;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultJsonReaderContractTests
extends JsonReaderContractTests {
    private JsonReader reader;
    String jsonWithComments = "{    // single line comment\n    \"single-line\": \"comment\",\n    /*\n    multi-line comment\n    */\n    \"multi-line\": \"comment\"}";

    @Override
    public JsonReader getJsonReader(String json) throws IOException {
        this.reader = DefaultJsonReader.fromString((String)json, (JsonOptions)new JsonOptions());
        return this.reader;
    }

    @AfterEach
    public void afterEach() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Test
    public void readJsonc() throws IOException {
        try (JsonReader jsonReader = DefaultJsonReader.fromString((String)this.jsonWithComments, (JsonOptions)new JsonOptions().setJsoncSupported(true));){
            jsonReader.nextToken();
            String outputJson = jsonReader.readChildren();
            Assertions.assertNotNull((Object)outputJson);
        }
    }

    @Test
    public void readJsoncFails() throws IOException {
        Assertions.assertThrows(JsonParseException.class, () -> {
            try (JsonReader jsonReader = this.getJsonReader(this.jsonWithComments);){
                jsonReader.nextToken();
                String outputJson = jsonReader.readChildren();
                Assertions.assertNotNull((Object)outputJson);
            }
        });
    }
}

