/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class AdditionalPropertiesJsonSerializable
implements JsonSerializable<AdditionalPropertiesJsonSerializable> {
    private final int anInt;
    private final boolean aBoolean;
    private String aString;
    private Double aNullableDecimal;
    private Map<String, Object> additionalProperties;

    public AdditionalPropertiesJsonSerializable(int anInt, boolean aBoolean) {
        this.anInt = anInt;
        this.aBoolean = aBoolean;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeIntField("int", this.anInt).writeBooleanField("boolean", this.aBoolean).writeStringField("string", this.aString).writeNumberField("decimal", (Number)this.aNullableDecimal);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AdditionalPropertiesJsonSerializable fromJson(JsonReader jsonReader) throws IOException {
        return (AdditionalPropertiesJsonSerializable)jsonReader.readObject(reader -> {
            int anInt = 0;
            boolean foundAnInt = false;
            boolean aBoolean = false;
            boolean foundABoolean = false;
            String aString = null;
            Double aNullableDecimal = null;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("int".equals(fieldName)) {
                    anInt = reader.getInt();
                    foundAnInt = true;
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    aBoolean = reader.getBoolean();
                    foundABoolean = true;
                    continue;
                }
                if ("string".equals(fieldName)) {
                    aString = reader.getString();
                    continue;
                }
                if ("decimal".equals(fieldName)) {
                    aNullableDecimal = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            if (foundAnInt && foundABoolean) {
                AdditionalPropertiesJsonSerializable value = new AdditionalPropertiesJsonSerializable(anInt, aBoolean);
                value.aString = aString;
                value.aNullableDecimal = aNullableDecimal;
                value.additionalProperties = additionalProperties;
                return value;
            }
            throw new IllegalStateException("Missing required JSON properties. Required properties are 'int' and 'boolean'.");
        });
    }
}

