/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.contract;

import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.ReadValueCallback;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class JsonReaderContractTests {
    private static final String JSON_WITH_COMMENTS = "{// single line comment\n\"single-line\":\"comment\",\n/*\nmulti-line comment\n*/\n\"multi-line\":\"comment\"}";

    private JsonReader getJsonReader(String json) throws IOException {
        return this.getJsonReader(json, new JsonOptions());
    }

    protected abstract JsonReader getJsonReader(String var1, JsonOptions var2) throws IOException;

    @ParameterizedTest
    @MethodSource(value={"basicOperationsSupplier"})
    public <T> void basicOperations(String json, T expectedValue, ReadValueCallback<JsonReader, T> function) throws IOException {
        this.readAndValidate(json, function, actual -> Assertions.assertEquals((Object)expectedValue, (Object)actual));
    }

    private static Stream<Arguments> basicOperationsSupplier() {
        UUID uuid = UUID.randomUUID();
        return Stream.of(Arguments.of((Object[])new Object[]{"false", false, JsonReaderContractTests.read(JsonReader::getBoolean)}), Arguments.of((Object[])new Object[]{"true", true, JsonReaderContractTests.read(JsonReader::getBoolean)}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(reader -> (Boolean)reader.getNullable(JsonReader::getBoolean))}), Arguments.of((Object[])new Object[]{"-42.0", -42.0, JsonReaderContractTests.read(JsonReader::getDouble)}), Arguments.of((Object[])new Object[]{"-42", -42.0, JsonReaderContractTests.read(JsonReader::getDouble)}), Arguments.of((Object[])new Object[]{"42.0", 42.0, JsonReaderContractTests.read(JsonReader::getDouble)}), Arguments.of((Object[])new Object[]{"42", 42.0, JsonReaderContractTests.read(JsonReader::getDouble)}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(reader -> (Double)reader.getNullable(JsonReader::getDouble))}), Arguments.of((Object[])new Object[]{"-42.0", Float.valueOf(-42.0f), JsonReaderContractTests.read(JsonReader::getFloat)}), Arguments.of((Object[])new Object[]{"-42", Float.valueOf(-42.0f), JsonReaderContractTests.read(JsonReader::getFloat)}), Arguments.of((Object[])new Object[]{"42.0", Float.valueOf(42.0f), JsonReaderContractTests.read(JsonReader::getFloat)}), Arguments.of((Object[])new Object[]{"42", Float.valueOf(42.0f), JsonReaderContractTests.read(JsonReader::getFloat)}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(reader -> (Float)reader.getNullable(JsonReader::getFloat))}), Arguments.of((Object[])new Object[]{"-42", -42, JsonReaderContractTests.read(JsonReader::getInt)}), Arguments.of((Object[])new Object[]{"42", 42, JsonReaderContractTests.read(JsonReader::getInt)}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(reader -> (Integer)reader.getNullable(JsonReader::getInt))}), Arguments.of((Object[])new Object[]{"-42", -42L, JsonReaderContractTests.read(JsonReader::getLong)}), Arguments.of((Object[])new Object[]{"42", 42L, JsonReaderContractTests.read(JsonReader::getLong)}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(reader -> (Long)reader.getNullable(JsonReader::getLong))}), Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(JsonReader::getString)}), Arguments.of((Object[])new Object[]{"\"\"", "", JsonReaderContractTests.read(JsonReader::getString)}), Arguments.of((Object[])new Object[]{"\"hello\"", "hello", JsonReaderContractTests.read(JsonReader::getString)}), Arguments.of((Object[])new Object[]{"\"" + uuid + "\"", uuid, JsonReaderContractTests.read(reader -> (UUID)reader.getNullable(reader1 -> UUID.fromString(reader1.getString())))}));
    }

    @ParameterizedTest
    @MethodSource(value={"binaryOperationsSupplier"})
    public void binaryOperations(String json, byte[] expectedValue, ReadValueCallback<JsonReader, byte[]> function) throws IOException {
        this.readAndValidate(json, function, actual -> Assertions.assertArrayEquals((byte[])expectedValue, (byte[])actual));
    }

    private static Stream<Arguments> binaryOperationsSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"null", null, JsonReaderContractTests.read(JsonReader::getBinary)}), Arguments.of((Object[])new Object[]{"\"\"", new byte[0], JsonReaderContractTests.read(JsonReader::getBinary)}), Arguments.of((Object[])new Object[]{"\"" + Base64.getEncoder().encodeToString("Hello".getBytes(StandardCharsets.UTF_8)) + "\"", "Hello".getBytes(StandardCharsets.UTF_8), JsonReaderContractTests.read(JsonReader::getBinary)}));
    }

    @Test
    public void emptyObject() throws IOException {
        String json = "{}";
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_OBJECT);
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                Assertions.fail((String)("Empty object shouldn't have any non-END_OBJECT JsonTokens but found: " + reader.currentToken()));
            }
        }
    }

    @Test
    public void emptyArray() throws IOException {
        String json = "[]";
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_ARRAY);
            while (reader.nextToken() != JsonToken.END_ARRAY) {
                Assertions.fail((String)("Empty array shouldn't have any non-END_ARRAY JsonTokens but found: " + reader.currentToken()));
            }
        }
    }

    @Test
    public void simpleObject() throws IOException {
        String json = "{\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"floatProperty\":10.0,\"booleanProperty\":true}";
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_OBJECT);
            String stringProperty = null;
            boolean hasNullProperty = false;
            int integerProperty = 0;
            float floatProperty = 0.0f;
            boolean booleanProperty = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stringProperty".equals(fieldName)) {
                    stringProperty = reader.getString();
                    continue;
                }
                if ("nullProperty".equals(fieldName)) {
                    hasNullProperty = true;
                    continue;
                }
                if ("integerProperty".equals(fieldName)) {
                    integerProperty = reader.getInt();
                    continue;
                }
                if ("floatProperty".equals(fieldName)) {
                    floatProperty = reader.getFloat();
                    continue;
                }
                if ("booleanProperty".equals(fieldName)) {
                    booleanProperty = reader.getBoolean();
                    continue;
                }
                Assertions.fail((String)("Unknown property name: '" + fieldName + "'"));
            }
            Assertions.assertEquals((Object)"string", stringProperty);
            Assertions.assertTrue((boolean)hasNullProperty, (String)"Didn't find the expected 'nullProperty'.");
            Assertions.assertEquals((int)10, (int)integerProperty);
            Assertions.assertEquals((float)10.0f, (float)floatProperty);
            Assertions.assertEquals((Object)true, (Object)booleanProperty);
        }
    }

    @Test
    public void arrayOfBasicTypesInJsonRoot() throws IOException {
        String json = "[\"string\",null,10,10.0,true]";
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_ARRAY);
            Object[] jsonArray = new Object[5];
            int jsonArrayIndex = 0;
            while (reader.nextToken() != JsonToken.END_ARRAY) {
                jsonArray[jsonArrayIndex++] = reader.readUntyped();
            }
            Assertions.assertEquals((Object)"string", (Object)jsonArray[0]);
            Assertions.assertNull((Object)jsonArray[1]);
            Assertions.assertEquals((Object)10, (Object)jsonArray[2]);
            Assertions.assertEquals((Object)10.0, (Object)jsonArray[3]);
            Assertions.assertEquals((Object)true, (Object)jsonArray[4]);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"objectWithInnerObjectSupplier"})
    public void objectWithInnerObject(String json) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_OBJECT);
            String stringProperty = null;
            boolean hasNullProperty = false;
            int integerProperty = 0;
            float floatProperty = 0.0f;
            boolean booleanProperty = false;
            String innerStringProperty = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stringProperty".equals(fieldName)) {
                    stringProperty = reader.getString();
                    continue;
                }
                if ("nullProperty".equals(fieldName)) {
                    hasNullProperty = true;
                    continue;
                }
                if ("integerProperty".equals(fieldName)) {
                    integerProperty = reader.getInt();
                    continue;
                }
                if ("floatProperty".equals(fieldName)) {
                    floatProperty = reader.getFloat();
                    continue;
                }
                if ("booleanProperty".equals(fieldName)) {
                    booleanProperty = reader.getBoolean();
                    continue;
                }
                if ("innerObject".equals(fieldName)) {
                    Assertions.assertEquals((Object)JsonToken.START_OBJECT, (Object)reader.currentToken());
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("innerStringProperty".equals(fieldName)) {
                            innerStringProperty = reader.getString();
                            continue;
                        }
                        Assertions.fail((String)("Unknown property name: '" + fieldName + "'"));
                    }
                    continue;
                }
                Assertions.fail((String)("Unknown property name: '" + fieldName + "'"));
            }
            Assertions.assertEquals((Object)"string", stringProperty);
            Assertions.assertTrue((boolean)hasNullProperty, (String)"Didn't find the expected 'nullProperty'.");
            Assertions.assertEquals((int)10, (int)integerProperty);
            Assertions.assertEquals((float)10.0f, (float)floatProperty);
            Assertions.assertEquals((Object)true, (Object)booleanProperty);
            Assertions.assertEquals((Object)"innerString", innerStringProperty);
        }
    }

    private static Stream<Arguments> objectWithInnerObjectSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerObjectAsFirstProperty", (Object)"{\"innerObject\":{\"innerStringProperty\":\"innerString\"},\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"floatProperty\":10.0,\"booleanProperty\":true}")}), Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerObjectAsMiddleProperty", (Object)"{\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"innerObject\":{\"innerStringProperty\":\"innerString\"},\"floatProperty\":10.0,\"booleanProperty\":true}")}), Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerObjectAsLastProperty", (Object)"{\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"floatProperty\":10.0,\"booleanProperty\":true,\"innerObject\":{\"innerStringProperty\":\"innerString\"}}")}));
    }

    @ParameterizedTest
    @MethodSource(value={"objectWithInnerArraySupplier"})
    public void objectWithInnerArray(String json) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_OBJECT);
            String stringProperty = null;
            boolean hasNullProperty = false;
            int integerProperty = 0;
            float floatProperty = 0.0f;
            boolean booleanProperty = false;
            String innerStringProperty = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stringProperty".equals(fieldName)) {
                    stringProperty = reader.getString();
                    continue;
                }
                if ("nullProperty".equals(fieldName)) {
                    hasNullProperty = true;
                    continue;
                }
                if ("integerProperty".equals(fieldName)) {
                    integerProperty = reader.getInt();
                    continue;
                }
                if ("floatProperty".equals(fieldName)) {
                    floatProperty = reader.getFloat();
                    continue;
                }
                if ("booleanProperty".equals(fieldName)) {
                    booleanProperty = reader.getBoolean();
                    continue;
                }
                if ("innerArray".equals(fieldName)) {
                    Assertions.assertEquals((Object)JsonToken.START_ARRAY, (Object)reader.currentToken());
                    while (reader.nextToken() != JsonToken.END_ARRAY) {
                        if (innerStringProperty != null) {
                            Assertions.fail((String)"Only expected one value in the inner array but found more.");
                        }
                        innerStringProperty = reader.getString();
                    }
                    continue;
                }
                Assertions.fail((String)("Unknown property name: '" + fieldName + "'"));
            }
            Assertions.assertEquals((Object)"string", stringProperty);
            Assertions.assertTrue((boolean)hasNullProperty, (String)"Didn't find the expected 'nullProperty'.");
            Assertions.assertEquals((int)10, (int)integerProperty);
            Assertions.assertEquals((float)10.0f, (float)floatProperty);
            Assertions.assertEquals((Object)true, (Object)booleanProperty);
            Assertions.assertEquals((Object)"innerString", innerStringProperty);
        }
    }

    private static Stream<Arguments> objectWithInnerArraySupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerArrayAsFirstProperty", (Object)"{\"innerArray\":[\"innerString\"],\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"floatProperty\":10.0,\"booleanProperty\":true}")}), Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerArrayAsMiddleProperty", (Object)"{\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"innerArray\":[\"innerString\"],\"floatProperty\":10.0,\"booleanProperty\":true}")}), Arguments.of((Object[])new Object[]{Named.of((String)"objectWithInnerArrayAsLastProperty", (Object)"{\"stringProperty\":\"string\",\"nullProperty\":null,\"integerProperty\":10,\"floatProperty\":10.0,\"booleanProperty\":true,\"innerArray\":[\"innerString\"]}")}));
    }

    @ParameterizedTest
    @MethodSource(value={"arrayWithInnerArraySupplier"})
    public void arrayWithInnerArray(String json) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_ARRAY);
            Object[] jsonArray = new Object[6];
            int jsonArrayIndex = 0;
            while (reader.nextToken() != JsonToken.END_ARRAY) {
                if (reader.currentToken() == JsonToken.START_ARRAY) {
                    while (reader.nextToken() != JsonToken.END_ARRAY) {
                        if (jsonArray[5] != null) {
                            Assertions.fail((String)"Only expected one value in the inner array but found more.");
                        }
                        jsonArray[5] = reader.getString();
                    }
                    continue;
                }
                jsonArray[jsonArrayIndex++] = reader.readUntyped();
            }
            Assertions.assertEquals((Object)"string", (Object)jsonArray[0]);
            Assertions.assertNull((Object)jsonArray[1]);
            Assertions.assertEquals((Object)10, (Object)jsonArray[2]);
            Assertions.assertEquals((Object)10.0, (Object)jsonArray[3]);
            Assertions.assertEquals((Object)true, (Object)jsonArray[4]);
            Assertions.assertEquals((Object)"innerString", (Object)jsonArray[5]);
        }
    }

    private static Stream<Arguments> arrayWithInnerArraySupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerArrayAsFirstProperty", (Object)"[[\"innerString\"],\"string\",null,10,10.0,true]")}), Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerArrayAsMiddleProperty", (Object)"[\"string\",null,10,[\"innerString\"],10.0,true]")}), Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerArrayAsLastProperty", (Object)"[\"string\",null,10,10.0,true,[\"innerString\"]]")}));
    }

    @ParameterizedTest
    @MethodSource(value={"arrayWithInnerObjectSupplier"})
    public void arrayWithInnerObject(String json) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            JsonReaderContractTests.assertJsonReaderStructInitialization(reader, JsonToken.START_ARRAY);
            Object[] jsonArray = new Object[6];
            int jsonArrayIndex = 0;
            while (reader.nextToken() != JsonToken.END_ARRAY) {
                if (reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("innerStringProperty".equals(fieldName)) {
                            jsonArray[5] = reader.getString();
                            continue;
                        }
                        Assertions.fail((String)("Unknown property name: '" + fieldName + "'"));
                    }
                    continue;
                }
                jsonArray[jsonArrayIndex++] = reader.readUntyped();
            }
            Assertions.assertEquals((Object)"string", (Object)jsonArray[0]);
            Assertions.assertNull((Object)jsonArray[1]);
            Assertions.assertEquals((Object)10, (Object)jsonArray[2]);
            Assertions.assertEquals((Object)10.0, (Object)jsonArray[3]);
            Assertions.assertEquals((Object)true, (Object)jsonArray[4]);
            Assertions.assertEquals((Object)"innerString", (Object)jsonArray[5]);
        }
    }

    private static Stream<Arguments> arrayWithInnerObjectSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerObjectAsFirstProperty", (Object)"[{\"innerStringProperty\":\"innerString\"},\"string\",null,10,10.0,true]")}), Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerObjectAsMiddleProperty", (Object)"[\"string\",null,10,{\"innerStringProperty\":\"innerString\"},10.0,true]")}), Arguments.of((Object[])new Object[]{Named.of((String)"arrayWithInnerObjectAsLastProperty", (Object)"[\"string\",null,10,10.0,true,{\"innerStringProperty\":\"innerString\"}]")}));
    }

    @ParameterizedTest
    @MethodSource(value={"readUntypedSimpleSupplier"})
    public void readUntypedSimple(String json, int nextCount, Object expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextCount; ++i) {
                reader.nextToken();
            }
            Object actual = reader.readUntyped();
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static Stream<Arguments> readUntypedSimpleSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"null", 1, null}), Arguments.of((Object[])new Object[]{"true", 1, true}), Arguments.of((Object[])new Object[]{"false", 1, false}), Arguments.of((Object[])new Object[]{"3.14", 1, 3.14}), Arguments.of((Object[])new Object[]{"NaN", 1, Double.NaN}), Arguments.of((Object[])new Object[]{"-Infinity", 1, Double.NEGATIVE_INFINITY}), Arguments.of((Object[])new Object[]{"Infinity", 1, Double.POSITIVE_INFINITY}), Arguments.of((Object[])new Object[]{"42", 1, 42}), Arguments.of((Object[])new Object[]{"420000000000", 1, 420000000000L}), Arguments.of((Object[])new Object[]{"\"hello\"", 1, "hello"}));
    }

    @ParameterizedTest
    @MethodSource(value={"readUntypedArraySupplier"})
    public void readUntypedArray(String json, int nextCount, List<Object> expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextCount; ++i) {
                reader.nextToken();
            }
            List actual = (List)reader.readUntyped();
            Assertions.assertIterableEquals(expected, (Iterable)actual);
        }
    }

    private static Stream<Arguments> readUntypedArraySupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"[]", 1, new ArrayList()}), Arguments.of((Object[])new Object[]{"[42,true,\"hello\"]", 1, Arrays.asList(42, true, "hello")}));
    }

    @ParameterizedTest
    @MethodSource(value={"readUntypedObjectSupplier"})
    public void readUntypedObject(String json, int nextCount, Map<String, Object> expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextCount; ++i) {
                reader.nextToken();
            }
            Map actual = (Map)reader.readUntyped();
            Assertions.assertEquals((int)expected.size(), (int)actual.size());
            for (Map.Entry<String, Object> expectedKvp : expected.entrySet()) {
                Assertions.assertTrue((boolean)actual.containsKey(expectedKvp.getKey()));
                Assertions.assertEquals((Object)expectedKvp.getValue(), actual.get(expectedKvp.getKey()));
            }
        }
    }

    private static Stream<Arguments> readUntypedObjectSupplier() {
        LinkedHashMap<String, Object> complexExpected = new LinkedHashMap<String, Object>();
        complexExpected.put("field1", 42);
        complexExpected.put("field2", true);
        complexExpected.put("field3", "hello");
        return Stream.of(Arguments.of((Object[])new Object[]{"{}", 1, new LinkedHashMap()}), Arguments.of((Object[])new Object[]{"{\"field1\":42,\"field2\":true,\"field3\":\"hello\"}", 1, complexExpected}));
    }

    @ParameterizedTest
    @MethodSource(value={"readUntypedIllegalStartSupplier"})
    public void readUntypedIllegalStart(String json, int nextCount) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextCount; ++i) {
                reader.nextToken();
            }
            Assertions.assertThrows(IllegalStateException.class, () -> ((JsonReader)reader).readUntyped());
        }
    }

    private static Stream<Arguments> readUntypedIllegalStartSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}", 2}), Arguments.of((Object[])new Object[]{"[]", 2}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 2}));
    }

    @Test
    public void readUntypedPreventsStackOverflow() throws IOException {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < 1001; ++i) {
            builder.append("{\"field\":");
        }
        builder.append("null");
        for (i = 0; i < 1001; ++i) {
            builder.append('}');
        }
        String deeplyNestJson = builder.toString();
        try (JsonReader reader = this.getJsonReader(deeplyNestJson);){
            reader.nextToken();
            Assertions.assertThrows(IllegalStateException.class, () -> ((JsonReader)reader).readUntyped());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bufferObjectSupplier"})
    public void bufferObject(String json, int nextCount) throws IOException {
        JsonReader reader = this.getJsonReader(json);
        for (int i = 0; i < nextCount; ++i) {
            reader.nextToken();
        }
        JsonReader buffer = reader.bufferObject();
        TestData testData = TestData.fromJson(buffer);
        Assertions.assertEquals((Object)"test", (Object)testData.getTest());
    }

    private static Stream<Arguments> bufferObjectSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{\"test\":\"test\"}", 1}), Arguments.of((Object[])new Object[]{"{\"outerfield\":{\"test\":\"test\"}}", 3}));
    }

    @ParameterizedTest
    @MethodSource(value={"bufferObjectIllegalStateSupplier"})
    public void bufferObjectIllegalState(String json, int nextCount) throws IOException {
        JsonReader reader = this.getJsonReader(json);
        for (int i = 0; i < nextCount; ++i) {
            reader.nextToken();
        }
        Assertions.assertThrows(IllegalStateException.class, () -> ((JsonReader)reader).bufferObject());
    }

    private static Stream<Arguments> bufferObjectIllegalStateSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"[]", 1}), Arguments.of((Object[])new Object[]{"12", 1}), Arguments.of((Object[])new Object[]{"null", 1}), Arguments.of((Object[])new Object[]{"true", 1}), Arguments.of((Object[])new Object[]{"\"hello\"", 1}), Arguments.of((Object[])new Object[]{"{\"outerfield\": 12}", 3}), Arguments.of((Object[])new Object[]{"{\"outerfield\": null}", 3}), Arguments.of((Object[])new Object[]{"{\"outerfield\": true}", 3}), Arguments.of((Object[])new Object[]{"{\"outerfield\": \"hello\"}", 3}));
    }

    @ParameterizedTest
    @MethodSource(value={"bufferHandlesEncodedTextSupplier"})
    public void bufferHandlesEncodedText(String json) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            reader.nextToken();
            String buffered = reader.readRemainingFieldsAsJsonObject();
            Assertions.assertEquals((Object)json, (Object)buffered);
        }
    }

    private static Stream<String> bufferHandlesEncodedTextSupplier() {
        return Stream.of("{\"encoded\\\"fieldname\":42}", "{\"fieldname\":\"encoded\\\"value\"}", "{\"encoded\\\"fieldname\":\"andencoded\\\"value\"}");
    }

    @Test
    public void getTextOnUninitializedReadThrowsIllegalStateException() throws IOException {
        try (JsonReader reader = this.getJsonReader("{}");){
            Assertions.assertThrows(IllegalStateException.class, () -> ((JsonReader)reader).getText());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTextSupplier"})
    public void getToken(String json, int nextTokens, String expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextTokens; ++i) {
                reader.nextToken();
            }
            Assertions.assertEquals((Object)expected, (Object)reader.getText());
        }
    }

    private static Stream<Arguments> getTextSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}", 1, "{"}), Arguments.of((Object[])new Object[]{"{}", 2, "}"}), Arguments.of((Object[])new Object[]{"[]", 1, "["}), Arguments.of((Object[])new Object[]{"[]", 2, "]"}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 2, "field"}), Arguments.of((Object[])new Object[]{"{\"\\\"field\\\"\":\"value\"}", 2, "\"field\""}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 3, "value"}), Arguments.of((Object[])new Object[]{"{\"field\":\"\\\"value\\\"\"}", 3, "\"value\""}), Arguments.of((Object[])new Object[]{"{\"field\":42}", 3, "42"}), Arguments.of((Object[])new Object[]{"{\"field\":42.0}", 3, "42.0"}), Arguments.of((Object[])new Object[]{"{\"field\":true}", 3, "true"}), Arguments.of((Object[])new Object[]{"{\"field\":false}", 3, "false"}), Arguments.of((Object[])new Object[]{"{\"field\":null}", 3, "null"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getRawTextSupplier"})
    public void getRawToken(String json, int nextTokens, String expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextTokens; ++i) {
                reader.nextToken();
            }
            Assertions.assertEquals((Object)expected, (Object)reader.getRawText());
        }
    }

    private static Stream<Arguments> getRawTextSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}", 1, "{"}), Arguments.of((Object[])new Object[]{"{}", 2, "}"}), Arguments.of((Object[])new Object[]{"[]", 1, "["}), Arguments.of((Object[])new Object[]{"[]", 2, "]"}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 2, "field"}), Arguments.of((Object[])new Object[]{"{\"\\\"field\\\"\":\"value\"}", 2, "\\\"field\\\""}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 3, "value"}), Arguments.of((Object[])new Object[]{"{\"field\":\"\\\"value\\\"\"}", 3, "\\\"value\\\""}), Arguments.of((Object[])new Object[]{"{\"field\":42}", 3, "42"}), Arguments.of((Object[])new Object[]{"{\"field\":42.0}", 3, "42.0"}), Arguments.of((Object[])new Object[]{"{\"field\":true}", 3, "true"}), Arguments.of((Object[])new Object[]{"{\"field\":false}", 3, "false"}), Arguments.of((Object[])new Object[]{"{\"field\":null}", 3, "null"}));
    }

    @ParameterizedTest
    @MethodSource(value={"isJsonStructSupplier"})
    public void isJsonStruct(String json, int nextTokens, boolean isStart, boolean expected) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            for (int i = 0; i < nextTokens; ++i) {
                reader.nextToken();
            }
            Assertions.assertEquals((Object)expected, (Object)(isStart ? reader.isStartArrayOrObject() : reader.isEndArrayOrObject()));
        }
    }

    private static Stream<Arguments> isJsonStructSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"{}", 1, true, true}), Arguments.of((Object[])new Object[]{"{}", 1, false, false}), Arguments.of((Object[])new Object[]{"{}", 2, true, false}), Arguments.of((Object[])new Object[]{"{}", 2, false, true}), Arguments.of((Object[])new Object[]{"[]", 1, true, true}), Arguments.of((Object[])new Object[]{"[]", 1, false, false}), Arguments.of((Object[])new Object[]{"[]", 2, true, false}), Arguments.of((Object[])new Object[]{"[]", 2, false, true}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 2, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 2, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":\"value\"}", 3, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":42}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":42}", 3, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":42.0}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":42.0}", 3, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":true}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":true}", 3, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":false}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":false}", 3, false, false}), Arguments.of((Object[])new Object[]{"{\"field\":null}", 3, true, false}), Arguments.of((Object[])new Object[]{"{\"field\":null}", 3, false, false}));
    }

    @Test
    public void readArrayNonStartArrayTokenThrowsIllegalStateException() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.getJsonReader("{}").readArray(JsonReader::readUntyped));
    }

    @ParameterizedTest
    @MethodSource(value={"readArraySupplier"})
    public void readArray(String json, ReadValueCallback<JsonReader, List<Object>> read, List<Object> expected) throws IOException {
        this.readAndValidate(json, read, actual -> {
            if (expected == null) {
                Assertions.assertNull((Object)actual);
            } else {
                Assertions.assertEquals((int)expected.size(), (int)actual.size());
                for (int i = 0; i < expected.size(); ++i) {
                    Assertions.assertEquals(expected.get(i), actual.get(i));
                }
            }
        });
    }

    private static Stream<Arguments> readArraySupplier() {
        ReadValueCallback reader = JsonReaderContractTests.read(r -> r.readArray(JsonReader::readUntyped));
        return Stream.of(Arguments.of((Object[])new Object[]{"null", reader, null}), Arguments.of((Object[])new Object[]{"[]", reader, Collections.emptyList()}), Arguments.of((Object[])new Object[]{"[10]", reader, Collections.singletonList(10)}), Arguments.of((Object[])new Object[]{"[true,10,10.0,\"hello\"]", reader, Arrays.asList(true, 10, 10.0, "hello")}));
    }

    @Test
    public void readMapNonStartObjectTokenThrowsIllegalStateException() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.getJsonReader("[]").readMap(JsonReader::readUntyped));
    }

    @ParameterizedTest
    @MethodSource(value={"readMapSupplier"})
    public void readMap(String json, ReadValueCallback<JsonReader, Map<String, Object>> read, Map<String, Object> expected) throws IOException {
        this.readAndValidate(json, read, actual -> {
            if (expected == null) {
                Assertions.assertNull((Object)actual);
            } else {
                Assertions.assertEquals((int)expected.size(), (int)actual.size());
                for (String expectedKey : expected.keySet()) {
                    Assertions.assertTrue((boolean)actual.containsKey(expectedKey));
                    Assertions.assertEquals(expected.get(expectedKey), actual.get(expectedKey));
                }
            }
        });
    }

    private static Stream<Arguments> readMapSupplier() {
        ReadValueCallback reader = JsonReaderContractTests.read(r -> r.readMap(JsonReader::readUntyped));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("boolean", true);
        map.put("int", 42);
        map.put("decimal", 42.0);
        map.put("string", "hello");
        return Stream.of(Arguments.of((Object[])new Object[]{"null", reader, null}), Arguments.of((Object[])new Object[]{"{}", reader, Collections.emptyMap()}), Arguments.of((Object[])new Object[]{"{\"boolean\":true,\"int\":42,\"decimal\":42.0,\"string\":\"hello\"}", reader, map}));
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @ParameterizedTest
    @MethodSource(value={"readUntypedExponentNumbersSupplier"})
    public void readUntypedExponentNumbers(String numberString, Number expected) throws IOException {
        this.readAndValidate(numberString, JsonReader::readUntyped, actual -> Assertions.assertEquals((Object)expected, (Object)actual));
    }

    private static Stream<Arguments> readUntypedExponentNumbersSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1e-1", 0.1}), Arguments.of((Object[])new Object[]{"1E-1", 0.1}), Arguments.of((Object[])new Object[]{"1e+1", 10.0}), Arguments.of((Object[])new Object[]{"1E+1", 10.0}), Arguments.of((Object[])new Object[]{"1e-01", 0.1}), Arguments.of((Object[])new Object[]{"1E-01", 0.1}), Arguments.of((Object[])new Object[]{"1e+01", 10.0}), Arguments.of((Object[])new Object[]{"1E+01", 10.0}), Arguments.of((Object[])new Object[]{"1e0", 1.0}), Arguments.of((Object[])new Object[]{"1E0", 1.0}), Arguments.of((Object[])new Object[]{"Infinity", Double.POSITIVE_INFINITY}), Arguments.of((Object[])new Object[]{"+Infinity", Double.POSITIVE_INFINITY}), Arguments.of((Object[])new Object[]{"-Infinity", Double.NEGATIVE_INFINITY}), Arguments.of((Object[])new Object[]{"NaN", Double.NaN}));
    }

    @Test
    public void readJsonc() throws IOException {
        try (JsonReader jsonReader = this.getJsonReader(JSON_WITH_COMMENTS, new JsonOptions().setJsoncSupported(true));){
            jsonReader.nextToken();
            String outputJson = jsonReader.readChildren();
            Assertions.assertNotNull((Object)outputJson);
        }
    }

    @Test
    public void readJsoncFails() {
        Assertions.assertThrows(IOException.class, () -> {
            try (JsonReader jsonReader = this.getJsonReader(JSON_WITH_COMMENTS);){
                jsonReader.nextToken();
                String outputJson = jsonReader.readChildren();
                Assertions.assertNotNull((Object)outputJson);
            }
        });
    }

    private static void assertJsonReaderStructInitialization(JsonReader reader, JsonToken expectedInitialToken) throws IOException {
        Assertions.assertNull((Object)reader.currentToken());
        reader.nextToken();
        Assertions.assertEquals((Object)expectedInitialToken, (Object)reader.currentToken());
    }

    private static <T> ReadValueCallback<JsonReader, T> read(ReadValueCallback<JsonReader, T> func) {
        return func;
    }

    private <T> void readAndValidate(String json, ReadValueCallback<JsonReader, T> read, Consumer<T> validate) throws IOException {
        try (JsonReader reader = this.getJsonReader(json);){
            reader.nextToken();
            validate.accept(read.read((Object)reader));
        }
    }

    private static final class TestData
    implements JsonSerializable<TestData> {
        private String test;

        private TestData() {
        }

        public String getTest() {
            return this.test;
        }

        public void setTest(String test) {
            this.test = test;
        }

        public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
            return jsonWriter.writeStartObject().writeStringField("test", this.test).writeEndObject();
        }

        public static TestData fromJson(JsonReader jsonReader) throws IOException {
            return (TestData)jsonReader.readObject(reader -> {
                TestData result = new TestData();
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("test".equals(fieldName)) {
                        result.setTest(reader.getString());
                        continue;
                    }
                    reader.skipChildren();
                }
                return result;
            });
        }
    }
}

