/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation;

import com.azure.json.JsonOptions;
import com.azure.json.JsonWriter;
import com.azure.json.contract.JsonWriterContractTests;
import com.azure.json.implementation.DefaultJsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class DefaultJsonWriterContractTests
extends JsonWriterContractTests {
    private ByteArrayOutputStream outputStream;
    private JsonWriter writer;

    @BeforeEach
    public void beforeEach() throws IOException {
        this.outputStream = new ByteArrayOutputStream();
        this.writer = DefaultJsonWriter.toStream((OutputStream)this.outputStream, (JsonOptions)new JsonOptions());
    }

    @AfterEach
    public void afterEach() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public JsonWriter getJsonWriter() {
        return this.writer;
    }

    @Override
    public String getJsonWriterContents() {
        try {
            this.writer.flush();
            return this.outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

