/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.BinaryData;
import com.azure.messaging.eventgrid.namespaces.EventGridSenderClientBuilder;
import com.azure.messaging.eventgrid.namespaces.implementation.EventGridSenderClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EventGridSenderClientBuilder.class, isAsync=true)
public final class EventGridSenderAsyncClient {
    private final EventGridSenderClientImpl serviceClient;
    private final String topicName;

    EventGridSenderAsyncClient(EventGridSenderClientImpl serviceClient, String topicName) {
        this.serviceClient = serviceClient;
        this.topicName = topicName;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> sendWithResponse(String topicName, BinaryData event, RequestOptions requestOptions) {
        return this.serviceClient.sendWithResponseAsync(topicName, event, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> sendEventsWithResponse(String topicName, BinaryData events, RequestOptions requestOptions) {
        return this.serviceClient.sendEventsWithResponseAsync(topicName, events, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> send(CloudEvent event) {
        RequestOptions requestOptions = new RequestOptions();
        return this.sendWithResponse(this.topicName, BinaryData.fromObject((Object)event), requestOptions).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> send(List<CloudEvent> events) {
        RequestOptions requestOptions = new RequestOptions();
        return this.sendEventsWithResponse(this.topicName, BinaryData.fromObject(events), requestOptions).then();
    }

    public String getTopicName() {
        return this.topicName;
    }
}

