/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.eventgrid.namespaces.EventGridServiceVersion;
import reactor.core.publisher.Mono;

public final class EventGridSenderClientImpl {
    private final EventGridSenderClientService service;
    private final String endpoint;
    private final EventGridServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public EventGridServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EventGridSenderClientImpl(String endpoint, EventGridServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EventGridSenderClientImpl(HttpPipeline httpPipeline, String endpoint, EventGridServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EventGridSenderClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, EventGridServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (EventGridSenderClientService)RestProxy.create(EventGridSenderClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> sendWithResponseAsync(String topicName, BinaryData event, RequestOptions requestOptions) {
        String contentType = "application/cloudevents+json; charset=utf-8";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.send(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, "application/cloudevents+json; charset=utf-8", "application/json", event, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> sendWithResponse(String topicName, BinaryData event, RequestOptions requestOptions) {
        String contentType = "application/cloudevents+json; charset=utf-8";
        String accept = "application/json";
        return this.service.sendSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, "application/cloudevents+json; charset=utf-8", "application/json", event, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> sendEventsWithResponseAsync(String topicName, BinaryData events, RequestOptions requestOptions) {
        String contentType = "application/cloudevents-batch+json; charset=utf-8";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendEvents(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, "application/cloudevents-batch+json; charset=utf-8", "application/json", events, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> sendEventsWithResponse(String topicName, BinaryData events, RequestOptions requestOptions) {
        String contentType = "application/cloudevents-batch+json; charset=utf-8";
        String accept = "application/json";
        return this.service.sendEventsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, "application/cloudevents-batch+json; charset=utf-8", "application/json", events, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="EventGridSenderClien")
    public static interface EventGridSenderClientService {
        @Post(value="/topics/{topicName}:publish")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> send(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/cloudevents+json; charset=utf-8") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/topics/{topicName}:publish")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> sendSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/cloudevents+json; charset=utf-8") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/topics/{topicName}:publish")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> sendEvents(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/cloudevents-batch+json; charset=utf-8") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/topics/{topicName}:publish")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> sendEventsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/cloudevents-batch+json; charset=utf-8") BinaryData var6, RequestOptions var7, Context var8);
    }
}

