/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces.models;

import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FailedLockToken
implements JsonSerializable<FailedLockToken> {
    private final String lockToken;
    private final ResponseError error;

    private FailedLockToken(String lockToken, ResponseError error) {
        this.lockToken = lockToken;
        this.error = error;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockToken", this.lockToken);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static FailedLockToken fromJson(JsonReader jsonReader) throws IOException {
        return (FailedLockToken)jsonReader.readObject(reader -> {
            String lockToken = null;
            ResponseError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lockToken".equals(fieldName)) {
                    lockToken = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new FailedLockToken(lockToken, error);
        });
    }
}

