/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.messaging.eventgrid.EventGridPublisherAsyncClient;
import com.azure.messaging.eventgrid.EventGridPublisherClientBuilder;
import com.azure.messaging.eventgrid.EventGridServiceVersion;
import java.time.OffsetDateTime;

@ServiceClient(builder=EventGridPublisherClientBuilder.class)
public final class EventGridPublisherClient<T> {
    private final EventGridPublisherAsyncClient<T> asyncClient;

    EventGridPublisherClient(EventGridPublisherAsyncClient<T> client) {
        this.asyncClient = client;
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime) {
        return EventGridPublisherAsyncClient.generateSas(endpoint, keyCredential, expirationTime, EventGridServiceVersion.getLatest());
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime, EventGridServiceVersion apiVersion) {
        return EventGridPublisherAsyncClient.generateSas(endpoint, keyCredential, expirationTime, apiVersion);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendEvents(Iterable<T> events) {
        this.asyncClient.sendEvents(events).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendEventsWithResponse(Iterable<T> events, Context context) {
        return (Response)this.asyncClient.sendEventsWithResponse(events, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendEvent(T event) {
        this.asyncClient.sendEvent(event).block();
    }
}

