/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class MediaLiveEventIngestHeartbeatEventData {
    static final ClientLogger LOGGER = new ClientLogger(MediaLiveEventIngestHeartbeatEventData.class);
    @JsonProperty(value="trackType", access=JsonProperty.Access.WRITE_ONLY)
    private String trackType;
    @JsonProperty(value="trackName", access=JsonProperty.Access.WRITE_ONLY)
    private String trackName;
    @JsonProperty(value="transcriptionLanguage", access=JsonProperty.Access.WRITE_ONLY)
    private String transcriptionLanguage;
    @JsonProperty(value="transcriptionState", access=JsonProperty.Access.WRITE_ONLY)
    private String transcriptionState;
    @JsonProperty(value="bitrate", access=JsonProperty.Access.WRITE_ONLY)
    private Long bitrate;
    @JsonProperty(value="incomingBitrate", access=JsonProperty.Access.WRITE_ONLY)
    private Long incomingBitrate;
    @JsonProperty(value="ingestDriftValue", access=JsonProperty.Access.WRITE_ONLY)
    private String ingestDriftValue;
    @JsonProperty(value="lastFragmentArrivalTime", access=JsonProperty.Access.WRITE_ONLY)
    private String lastFragmentArrivalTime;
    @JsonProperty(value="lastTimestamp", access=JsonProperty.Access.WRITE_ONLY)
    private String lastTimestamp;
    @JsonProperty(value="timescale", access=JsonProperty.Access.WRITE_ONLY)
    private String timescale;
    @JsonProperty(value="overlapCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long overlapCount;
    @JsonProperty(value="discontinuityCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long discontinuityCount;
    @JsonProperty(value="nonincreasingCount", access=JsonProperty.Access.WRITE_ONLY)
    private Long nonincreasingCount;
    @JsonProperty(value="unexpectedBitrate", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean unexpectedBitrate;
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="healthy", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean healthy;

    public String getTrackType() {
        return this.trackType;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public String getTranscriptionLanguage() {
        return this.transcriptionLanguage;
    }

    public String getTranscriptionState() {
        return this.transcriptionState;
    }

    public Long getBitrate() {
        return this.bitrate;
    }

    public Long getIncomingBitrate() {
        return this.incomingBitrate;
    }

    public Integer getIngestDriftValue() {
        if ("n/a".equals(this.ingestDriftValue)) {
            return null;
        }
        try {
            return Integer.parseInt(this.ingestDriftValue);
        }
        catch (NumberFormatException ex) {
            LOGGER.logExceptionAsError((RuntimeException)ex);
            return null;
        }
    }

    public OffsetDateTime getLastFragmentArrivalTime() {
        return OffsetDateTime.parse(this.lastFragmentArrivalTime);
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public String getTimescale() {
        return this.timescale;
    }

    public Long getOverlapCount() {
        return this.overlapCount;
    }

    public Long getDiscontinuityCount() {
        return this.discontinuityCount;
    }

    public Long getNonincreasingCount() {
        return this.nonincreasingCount;
    }

    public Boolean isUnexpectedBitrate() {
        return this.unexpectedBitrate;
    }

    public String getState() {
        return this.state;
    }

    public Boolean isHealthy() {
        return this.healthy;
    }
}

