/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class EventGridEvent {
    private final com.azure.messaging.eventgrid.implementation.models.EventGridEvent event;
    private static final ClientLogger LOGGER;
    private static final JsonSerializer SERIALIZER;
    private static final TypeReference<List<com.azure.messaging.eventgrid.implementation.models.EventGridEvent>> DESERIALIZER_TYPE_REFERENCE;
    private static final ObjectMapper BINARY_DATA_OBJECT_MAPPER;
    private BinaryData binaryData;

    public EventGridEvent(String subject, String eventType, BinaryData data, String dataVersion) {
        Objects.requireNonNull(subject, "'subject' cannot be null.");
        Objects.requireNonNull(eventType, "'eventType' cannot be null.");
        Objects.requireNonNull(data, "'data' cannot be null");
        Objects.requireNonNull(dataVersion, "'dataVersion' cannot be null");
        this.event = new com.azure.messaging.eventgrid.implementation.models.EventGridEvent().setEventTime(OffsetDateTime.now()).setId(UUID.randomUUID().toString()).setSubject(subject).setEventType(eventType).setDataVersion(dataVersion);
        this.binaryData = data;
        try {
            this.event.setData(BINARY_DATA_OBJECT_MAPPER.readTree(data.toBytes()));
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'data' isn't in valid Json format", e));
        }
    }

    public static List<EventGridEvent> fromString(String eventGridJsonString) {
        try {
            List internalEvents = (List)SERIALIZER.deserialize((InputStream)new ByteArrayInputStream(eventGridJsonString.getBytes(StandardCharsets.UTF_8)), DESERIALIZER_TYPE_REFERENCE);
            ArrayList<EventGridEvent> events = new ArrayList<EventGridEvent>();
            for (int i = 0; i < internalEvents.size(); ++i) {
                com.azure.messaging.eventgrid.implementation.models.EventGridEvent internalEvent = (com.azure.messaging.eventgrid.implementation.models.EventGridEvent)internalEvents.get(i);
                if (internalEvent.getSubject() == null || internalEvent.getEventType() == null || internalEvent.getData() == null || internalEvent.getDataVersion() == null) {
                    ArrayList<String> nullAttributes = new ArrayList<String>();
                    if (internalEvent.getSubject() == null) {
                        nullAttributes.add("'subject'");
                    }
                    if (internalEvent.getEventType() == null) {
                        nullAttributes.add("'eventType'");
                    }
                    if (internalEvent.getData() == null) {
                        nullAttributes.add("'data'");
                    }
                    if (internalEvent.getDataVersion() == null) {
                        nullAttributes.add("'dataVersion'");
                    }
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'subject', 'eventType', 'data' and 'dataVersion' are mandatory attributes for an EventGridEvent. This Json string doesn't have " + String.join((CharSequence)",", nullAttributes) + " for the object at index " + i + ". Please make sure the input Json string has the required attributes"));
                }
                events.add(new EventGridEvent(internalEvent));
            }
            return events;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The input parameter isn't a JSON string.", uncheckedIOException.getCause()));
        }
    }

    public String getId() {
        return this.event.getId();
    }

    public EventGridEvent setId(String id) {
        Objects.requireNonNull(id, "'id' cannot be null.");
        if (id.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'id' cannot be empty."));
        }
        this.event.setId(id);
        return this;
    }

    public String getTopic() {
        return this.event.getTopic();
    }

    public EventGridEvent setTopic(String topic) {
        this.event.setTopic(topic);
        return this;
    }

    public String getSubject() {
        return this.event.getSubject();
    }

    public BinaryData getData() {
        Object data;
        if (this.binaryData == null && (data = this.event.getData()) != null) {
            this.binaryData = BinaryData.fromObject((Object)data, (ObjectSerializer)SERIALIZER);
        }
        return this.binaryData;
    }

    public String getEventType() {
        return this.event.getEventType();
    }

    public OffsetDateTime getEventTime() {
        return this.event.getEventTime();
    }

    public EventGridEvent setEventTime(OffsetDateTime time) {
        this.event.setEventTime(time);
        return this;
    }

    public String getDataVersion() {
        return this.event.getDataVersion();
    }

    EventGridEvent(com.azure.messaging.eventgrid.implementation.models.EventGridEvent impl) {
        this.event = impl;
    }

    com.azure.messaging.eventgrid.implementation.models.EventGridEvent toImpl() {
        return this.event;
    }

    static {
        JsonSerializer tmp;
        LOGGER = new ClientLogger(EventGridEvent.class);
        try {
            tmp = JsonSerializerProviders.createInstance();
        }
        catch (IllegalStateException e) {
            tmp = new JacksonSerializer();
        }
        SERIALIZER = tmp;
        DESERIALIZER_TYPE_REFERENCE = new TypeReference<List<com.azure.messaging.eventgrid.implementation.models.EventGridEvent>>(){};
        BINARY_DATA_OBJECT_MAPPER = new ObjectMapper();
    }

    private static class JacksonSerializer
    implements JsonSerializer {
        private final SerializerAdapter jacksonAdapter = JacksonAdapter.createDefaultSerializerAdapter();

        private JacksonSerializer() {
        }

        public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
            try {
                return (T)this.jacksonAdapter.deserialize(stream, typeReference.getJavaType(), SerializerEncoding.JSON);
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
            }
        }

        public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
            return Mono.defer(() -> Mono.fromCallable(() -> this.deserialize(stream, typeReference)));
        }

        public void serialize(OutputStream stream, Object value) {
            try {
                this.jacksonAdapter.serialize(value, SerializerEncoding.JSON, stream);
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
            }
        }

        public Mono<Void> serializeAsync(OutputStream stream, Object value) {
            return Mono.fromRunnable(() -> this.serialize(stream, value));
        }
    }
}

