/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureKeyCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.TracerProxy;
import com.azure.messaging.eventgrid.EventGridEvent;
import com.azure.messaging.eventgrid.EventGridPublisherAsyncClient;
import com.azure.messaging.eventgrid.EventGridPublisherClient;
import com.azure.messaging.eventgrid.EventGridServiceVersion;
import com.azure.messaging.eventgrid.implementation.CloudEventTracingPipelinePolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={EventGridPublisherClient.class, EventGridPublisherAsyncClient.class})
public final class EventGridPublisherClientBuilder
implements TokenCredentialTrait<EventGridPublisherClientBuilder>,
AzureKeyCredentialTrait<EventGridPublisherClientBuilder>,
AzureSasCredentialTrait<EventGridPublisherClientBuilder>,
HttpTrait<EventGridPublisherClientBuilder>,
ConfigurationTrait<EventGridPublisherClientBuilder>,
EndpointTrait<EventGridPublisherClientBuilder> {
    private static final String AEG_SAS_KEY = "aeg-sas-key";
    private static final String AEG_SAS_TOKEN = "aeg-sas-token";
    private static final String EVENTGRID_PROPERTIES = "azure-messaging-eventgrid.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String DEFAULT_EVENTGRID_SCOPE = "https://eventgrid.azure.net/.default";
    private final String clientName;
    private final String clientVersion;
    private final ClientLogger logger = new ClientLogger(EventGridPublisherClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private Configuration configuration;
    private AzureKeyCredential keyCredential;
    private AzureSasCredential sasToken;
    private TokenCredential tokenCredential;
    private EventGridServiceVersion serviceVersion;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;

    public EventGridPublisherClientBuilder() {
        Map properties = CoreUtils.getProperties((String)EVENTGRID_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
    }

    private <T> EventGridPublisherAsyncClient<T> buildAsyncClient(Class<T> eventClass) {
        EventGridServiceVersion buildServiceVersion;
        Objects.requireNonNull(this.endpoint, "'endpoint' is required and can not be null.");
        EventGridServiceVersion eventGridServiceVersion = buildServiceVersion = this.serviceVersion == null ? EventGridServiceVersion.getLatest() : this.serviceVersion;
        if (this.httpPipeline != null) {
            return new EventGridPublisherAsyncClient<T>(this.httpPipeline, this.endpoint, buildServiceVersion, eventClass);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ArrayList<Object> httpPipelinePolicies = new ArrayList<Object>();
        String applicationId = this.clientOptions == null ? this.httpLogOptions.getApplicationId() : this.clientOptions.getApplicationId();
        httpPipelinePolicies.add(new UserAgentPolicy(applicationId, this.clientName, this.clientVersion, buildConfiguration));
        httpPipelinePolicies.add(new RequestIdPolicy());
        HttpPolicyProviders.addBeforeRetryPolicies(httpPipelinePolicies);
        httpPipelinePolicies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        httpPipelinePolicies.add(new AddDatePolicy());
        int credentialCount = (this.sasToken != null ? 1 : 0) + (this.keyCredential != null ? 1 : 0) + (this.tokenCredential != null ? 1 : 0);
        if (credentialCount > 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("More than 1 credentials are set while building a client. You should set one and only one credential of type 'TokenCredential', 'AzureSasCredential', or 'AzureKeyCredential'."));
        }
        if (credentialCount == 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Missing credential information while building a client.You should set one and only one credential of type 'TokenCredential', 'AzureSasCredential', or 'AzureKeyCredential'."));
        }
        if (this.sasToken != null) {
            httpPipelinePolicies.add((context, next) -> {
                context.getHttpRequest().getHeaders().set(AEG_SAS_TOKEN, this.sasToken.getSignature());
                return next.process();
            });
        } else if (this.keyCredential != null) {
            httpPipelinePolicies.add(new AzureKeyCredentialPolicy(AEG_SAS_KEY, this.keyCredential));
        } else {
            httpPipelinePolicies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{DEFAULT_EVENTGRID_SCOPE}));
        }
        httpPipelinePolicies.addAll(this.policies);
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            this.policies.add((HttpPipelinePolicy)new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        HttpPolicyProviders.addAfterRetryPolicies(httpPipelinePolicies);
        if (TracerProxy.isTracingEnabled()) {
            httpPipelinePolicies.add(new CloudEventTracingPipelinePolicy());
        }
        httpPipelinePolicies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline buildPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(httpPipelinePolicies.toArray(new HttpPipelinePolicy[0])).clientOptions(this.clientOptions).build();
        return new EventGridPublisherAsyncClient<T>(buildPipeline, this.endpoint, buildServiceVersion, eventClass);
    }

    private <T> EventGridPublisherClient<T> buildClient(Class<T> eventClass) {
        return new EventGridPublisherClient<T>(this.buildAsyncClient(eventClass));
    }

    public EventGridPublisherClientBuilder addPolicy(HttpPipelinePolicy httpPipelinePolicy) {
        this.policies.add(Objects.requireNonNull(httpPipelinePolicy));
        return this;
    }

    public EventGridPublisherClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public EventGridPublisherClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public EventGridPublisherClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public EventGridPublisherClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public EventGridPublisherClientBuilder credential(AzureKeyCredential credential) {
        this.keyCredential = credential;
        return this;
    }

    public EventGridPublisherClientBuilder credential(AzureSasCredential credential) {
        this.sasToken = credential;
        return this;
    }

    public EventGridPublisherClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        return this;
    }

    public EventGridPublisherClientBuilder endpoint(String endpoint) {
        try {
            new URL(Objects.requireNonNull(endpoint, "'endpoint' cannot be null."));
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public EventGridPublisherClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("Http client is set to null when it was not previously null");
        }
        this.httpClient = httpClient;
        return this;
    }

    public EventGridPublisherClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public EventGridPublisherClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("Http client is set to null when it was not previously null");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public EventGridPublisherClientBuilder serviceVersion(EventGridServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public EventGridPublisherAsyncClient<CloudEvent> buildCloudEventPublisherAsyncClient() {
        return this.buildAsyncClient(CloudEvent.class);
    }

    public EventGridPublisherAsyncClient<EventGridEvent> buildEventGridEventPublisherAsyncClient() {
        return this.buildAsyncClient(EventGridEvent.class);
    }

    public EventGridPublisherAsyncClient<BinaryData> buildCustomEventPublisherAsyncClient() {
        return this.buildAsyncClient(BinaryData.class);
    }

    public EventGridPublisherClient<CloudEvent> buildCloudEventPublisherClient() {
        return this.buildClient(CloudEvent.class);
    }

    public EventGridPublisherClient<EventGridEvent> buildEventGridEventPublisherClient() {
        return this.buildClient(EventGridEvent.class);
    }

    public EventGridPublisherClient<BinaryData> buildCustomEventPublisherClient() {
        return this.buildClient(BinaryData.class);
    }
}

