/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public final class MediaLiveEventChannelArchiveHeartbeatEventData {
    static final ClientLogger LOGGER = new ClientLogger(MediaLiveEventChannelArchiveHeartbeatEventData.class);
    @JsonProperty(value="channelLatencyMs", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private String channelLatencyMs;
    @JsonProperty(value="latencyResultCode", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private String latencyResultCode;

    public Duration getChannelLatency() {
        Long channelLatencyMsLong;
        if ("n/a".equals(this.channelLatencyMs)) {
            return null;
        }
        try {
            channelLatencyMsLong = Long.parseLong(this.channelLatencyMs);
        }
        catch (NumberFormatException ex) {
            LOGGER.logExceptionAsError((RuntimeException)ex);
            return null;
        }
        return Duration.ofMillis(channelLatencyMsLong);
    }

    public String getLatencyResultCode() {
        return this.latencyResultCode;
    }
}

