/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.TracerProxy;
import com.azure.messaging.eventgrid.EventGridPublisherClientBuilder;
import com.azure.messaging.eventgrid.EventGridServiceVersion;
import com.azure.messaging.eventgrid.implementation.EventGridPublisherClientImpl;
import com.azure.messaging.eventgrid.implementation.EventGridPublisherClientImplBuilder;
import com.azure.messaging.eventgrid.implementation.models.EventGridEvent;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EventGridPublisherClientBuilder.class, isAsync=true)
public final class EventGridPublisherAsyncClient<T> {
    private static final String PARTNER_CHANNEL_HEADER_NAME = "aeg-channel-name";
    private final String hostname;
    private final EventGridPublisherClientImpl impl;
    private final ClientLogger logger = new ClientLogger(EventGridPublisherAsyncClient.class);
    private final Class<T> eventClass;
    private static final DateTimeFormatter SAS_DATE_TIME_FORMATER = DateTimeFormatter.ofPattern("M/d/yyyy h:m:s a");
    private static final String HMAC_SHA256 = "hmacSHA256";
    private static final String API_VERSION = "api-version";
    private static final ClientLogger LOGGER = new ClientLogger(EventGridPublisherAsyncClient.class);

    EventGridPublisherAsyncClient(HttpPipeline pipeline, String hostname, EventGridServiceVersion serviceVersion, Class<T> eventClass) {
        this.impl = new EventGridPublisherClientImplBuilder().pipeline(pipeline).apiVersion(serviceVersion.getVersion()).buildClient();
        this.hostname = hostname;
        this.eventClass = eventClass;
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime) {
        return EventGridPublisherAsyncClient.generateSas(endpoint, keyCredential, expirationTime, EventGridServiceVersion.getLatest());
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime, EventGridServiceVersion apiVersion) {
        if (Objects.isNull(endpoint)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'endpoint' cannot be null."));
        }
        if (Objects.isNull(keyCredential)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'keyCredetial' cannot be null."));
        }
        if (Objects.isNull(expirationTime)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'expirationTime' cannot be null."));
        }
        try {
            String resKey = "r";
            String expKey = "e";
            String signKey = "s";
            Charset charset = StandardCharsets.UTF_8;
            endpoint = String.format("%s?%s=%s", endpoint, API_VERSION, apiVersion.getVersion());
            String encodedResource = URLEncoder.encode(endpoint, charset.name());
            String encodedExpiration = URLEncoder.encode(expirationTime.atZoneSameInstant(ZoneOffset.UTC).format(SAS_DATE_TIME_FORMATER), charset.name());
            String unsignedSas = String.format("%s=%s&%s=%s", resKey, encodedResource, expKey, encodedExpiration);
            Mac hmac = Mac.getInstance(HMAC_SHA256);
            hmac.init(new SecretKeySpec(Base64.getDecoder().decode(keyCredential.getKey()), HMAC_SHA256));
            String signature = new String(Base64.getEncoder().encode(hmac.doFinal(unsignedSas.getBytes(charset))), charset);
            String encodedSignature = URLEncoder.encode(signature, charset.name());
            return String.format("%s&%s=%s", unsignedSas, signKey, encodedSignature);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendEvents(Iterable<T> events) {
        return FluxUtil.withContext(context -> this.sendEvents(events, (Context)context));
    }

    Mono<Void> sendEvents(Iterable<T> events, Context context) {
        if (this.eventClass == CloudEvent.class) {
            return this.sendCloudEvents(events, context);
        }
        if (this.eventClass == com.azure.messaging.eventgrid.EventGridEvent.class) {
            return this.sendEventGridEvents(events, context);
        }
        return this.sendCustomEvents(events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendEventsWithResponse(Iterable<T> events) {
        return FluxUtil.withContext(context -> this.sendEventsWithResponse(events, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendEventsWithResponse(Iterable<T> events, String channelName) {
        return FluxUtil.withContext(context -> this.sendEventsWithResponse(events, channelName, (Context)context));
    }

    Mono<Response<Void>> sendEventsWithResponse(Iterable<T> events, Context context) {
        return this.sendEventsWithResponse(events, null, context);
    }

    Mono<Response<Void>> sendEventsWithResponse(Iterable<T> events, String channelName, Context context) {
        if (context == null) {
            context = Context.NONE;
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)channelName)) {
            String requestHttpHeadersKey = "azure-http-headers-key";
            Map keyValues = context.getValues();
            if (keyValues != null && keyValues.containsKey(requestHttpHeadersKey)) {
                Object value = keyValues.get(requestHttpHeadersKey);
                if (value instanceof HttpHeaders) {
                    HttpHeaders headers = (HttpHeaders)value;
                    headers.add(PARTNER_CHANNEL_HEADER_NAME, channelName);
                }
            } else {
                context = context.addData((Object)requestHttpHeadersKey, (Object)new HttpHeaders().add(PARTNER_CHANNEL_HEADER_NAME, channelName));
            }
        }
        if (this.eventClass == CloudEvent.class) {
            return this.sendCloudEventsWithResponse(events, context);
        }
        if (this.eventClass == com.azure.messaging.eventgrid.EventGridEvent.class) {
            return this.sendEventGridEventsWithResponse(events, context);
        }
        return this.sendCustomEventsWithResponse(events, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendEvent(T event) {
        List<T> events = Collections.singletonList(event);
        return FluxUtil.withContext(context -> this.sendEvents((Iterable<T>)events, (Context)context));
    }

    Mono<Void> sendEventGridEvents(Iterable<com.azure.messaging.eventgrid.EventGridEvent> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        return Flux.fromIterable(events).map(com.azure.messaging.eventgrid.EventGridEvent::toImpl).collectList().flatMap(list -> this.impl.publishEventsAsync(this.hostname, (List<EventGridEvent>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    Mono<Void> sendCloudEvents(Iterable<CloudEvent> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        this.addCloudEventTracePlaceHolder(events);
        return Flux.fromIterable(events).collectList().flatMap(list -> this.impl.publishCloudEventEventsAsync(this.hostname, (List<CloudEvent>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    Mono<Void> sendCustomEvents(Iterable<BinaryData> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        return Flux.fromIterable(events).map(event -> new RawValue(event.toString())).collectList().flatMap(list -> this.impl.publishCustomEventEventsAsync(this.hostname, (List<Object>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    Mono<Response<Void>> sendEventGridEventsWithResponse(Iterable<com.azure.messaging.eventgrid.EventGridEvent> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        return Flux.fromIterable(events).map(com.azure.messaging.eventgrid.EventGridEvent::toImpl).collectList().flatMap(list -> this.impl.publishEventsWithResponseAsync(this.hostname, (List<EventGridEvent>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    Mono<Response<Void>> sendCloudEventsWithResponse(Iterable<CloudEvent> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        this.addCloudEventTracePlaceHolder(events);
        return Flux.fromIterable(events).collectList().flatMap(list -> this.impl.publishCloudEventEventsWithResponseAsync(this.hostname, (List<CloudEvent>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    Mono<Response<Void>> sendCustomEventsWithResponse(Iterable<BinaryData> events, Context context) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        Context finalContext = context != null ? context : Context.NONE;
        return Flux.fromIterable(events).map(event -> new RawValue(event.toString())).collectList().flatMap(list -> this.impl.publishCustomEventEventsWithResponseAsync(this.hostname, (List<Object>)list, finalContext.addData((Object)"az.namespace", (Object)"Microsoft.EventGrid")));
    }

    private void addCloudEventTracePlaceHolder(Iterable<CloudEvent> events) {
        if (TracerProxy.isTracingEnabled()) {
            for (CloudEvent event : events) {
                if (event.getExtensionAttributes() != null && (event.getExtensionAttributes().get("traceparent") != null || event.getExtensionAttributes().get("tracestate") != null)) continue;
                event.addExtensionAttribute("traceparent", (Object)"TP-14b6b15b-74b6-4178-847e-d142aa2727b2");
                event.addExtensionAttribute("tracestate", (Object)"TS-14b6b15b-74b6-4178-847e-d142aa2727b2");
            }
        }
    }
}

