// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of common properties of all thread-level chat events. */
@Fluent
public class AcsChatEventInThreadBaseProperties {
    /*
     * The transaction id will be used as co-relation vector
     */
    @JsonProperty(value = "transactionId")
    private String transactionId;

    /*
     * The chat thread id
     */
    @JsonProperty(value = "threadId")
    private String threadId;

    /** Creates an instance of AcsChatEventInThreadBaseProperties class. */
    public AcsChatEventInThreadBaseProperties() {}

    /**
     * Get the transactionId property: The transaction id will be used as co-relation vector.
     *
     * @return the transactionId value.
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * Set the transactionId property: The transaction id will be used as co-relation vector.
     *
     * @param transactionId the transactionId value to set.
     * @return the AcsChatEventInThreadBaseProperties object itself.
     */
    public AcsChatEventInThreadBaseProperties setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    /**
     * Get the threadId property: The chat thread id.
     *
     * @return the threadId value.
     */
    public String getThreadId() {
        return this.threadId;
    }

    /**
     * Set the threadId property: The chat thread id.
     *
     * @param threadId the threadId value to set.
     * @return the AcsChatEventInThreadBaseProperties object itself.
     */
    public AcsChatEventInThreadBaseProperties setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }
}
