// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The AcsChatMemberAddedToThreadWithUserEventData model. */
@Fluent
public final class AcsChatMemberAddedToThreadWithUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The time at which the user was added to the thread
     */
    @JsonProperty(value = "time")
    private OffsetDateTime time;

    /*
     * The MRI of the user who added the user
     */
    @JsonProperty(value = "addedBy")
    private String addedBy;

    /*
     * The details of the user who was added
     */
    @JsonProperty(value = "memberAdded")
    private AcsChatThreadMemberProperties memberAdded;

    /**
     * Get the time property: The time at which the user was added to the thread.
     *
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was added to the thread.
     *
     * @param time the time value to set.
     * @return the AcsChatMemberAddedToThreadWithUserEventData object itself.
     */
    public AcsChatMemberAddedToThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the addedBy property: The MRI of the user who added the user.
     *
     * @return the addedBy value.
     */
    public String getAddedBy() {
        return this.addedBy;
    }

    /**
     * Set the addedBy property: The MRI of the user who added the user.
     *
     * @param addedBy the addedBy value to set.
     * @return the AcsChatMemberAddedToThreadWithUserEventData object itself.
     */
    public AcsChatMemberAddedToThreadWithUserEventData setAddedBy(String addedBy) {
        this.addedBy = addedBy;
        return this;
    }

    /**
     * Get the memberAdded property: The details of the user who was added.
     *
     * @return the memberAdded value.
     */
    public AcsChatThreadMemberProperties getMemberAdded() {
        return this.memberAdded;
    }

    /**
     * Set the memberAdded property: The details of the user who was added.
     *
     * @param memberAdded the memberAdded value to set.
     * @return the AcsChatMemberAddedToThreadWithUserEventData object itself.
     */
    public AcsChatMemberAddedToThreadWithUserEventData setMemberAdded(AcsChatThreadMemberProperties memberAdded) {
        this.memberAdded = memberAdded;
        return this;
    }
}
