// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The AcsChatMemberRemovedFromThreadWithUserEventData model. */
@Fluent
public final class AcsChatMemberRemovedFromThreadWithUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The time at which the user was removed to the thread
     */
    @JsonProperty(value = "time")
    private OffsetDateTime time;

    /*
     * The MRI of the user who removed the user
     */
    @JsonProperty(value = "removedBy")
    private String removedBy;

    /*
     * The details of the user who was removed
     */
    @JsonProperty(value = "memberRemoved")
    private AcsChatThreadMemberProperties memberRemoved;

    /**
     * Get the time property: The time at which the user was removed to the thread.
     *
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was removed to the thread.
     *
     * @param time the time value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the removedBy property: The MRI of the user who removed the user.
     *
     * @return the removedBy value.
     */
    public String getRemovedBy() {
        return this.removedBy;
    }

    /**
     * Set the removedBy property: The MRI of the user who removed the user.
     *
     * @param removedBy the removedBy value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData setRemovedBy(String removedBy) {
        this.removedBy = removedBy;
        return this;
    }

    /**
     * Get the memberRemoved property: The details of the user who was removed.
     *
     * @return the memberRemoved value.
     */
    public AcsChatThreadMemberProperties getMemberRemoved() {
        return this.memberRemoved;
    }

    /**
     * Set the memberRemoved property: The details of the user who was removed.
     *
     * @param memberRemoved the memberRemoved value to set.
     * @return the AcsChatMemberRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatMemberRemovedFromThreadWithUserEventData setMemberRemoved(
            AcsChatThreadMemberProperties memberRemoved) {
        this.memberRemoved = memberRemoved;
        return this;
    }
}
