// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageDeletedInThread event. */
@Fluent
public final class AcsChatMessageDeletedInThreadEventData extends AcsChatMessageEventInThreadBaseProperties {
    /*
     * The time at which the message was deleted
     */
    @JsonProperty(value = "deleteTime")
    private OffsetDateTime deleteTime;

    /** Creates an instance of AcsChatMessageDeletedInThreadEventData class. */
    public AcsChatMessageDeletedInThreadEventData() {}

    /**
     * Get the deleteTime property: The time at which the message was deleted.
     *
     * @return the deleteTime value.
     */
    public OffsetDateTime getDeleteTime() {
        return this.deleteTime;
    }

    /**
     * Set the deleteTime property: The time at which the message was deleted.
     *
     * @param deleteTime the deleteTime value to set.
     * @return the AcsChatMessageDeletedInThreadEventData object itself.
     */
    public AcsChatMessageDeletedInThreadEventData setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setSenderCommunicationIdentifier(
            CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageDeletedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }
}
