// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatMessageEditedInThread event. */
@Fluent
public final class AcsChatMessageEditedInThreadEventData extends AcsChatMessageEventInThreadBaseProperties {
    /*
     * The body of the chat message
     */
    @JsonProperty(value = "messageBody")
    private String messageBody;

    /*
     * The chat message metadata
     */
    @JsonProperty(value = "metadata")
    private Map<String, String> metadata;

    /*
     * The time at which the message was edited
     */
    @JsonProperty(value = "editTime")
    private OffsetDateTime editTime;

    /** Creates an instance of AcsChatMessageEditedInThreadEventData class. */
    public AcsChatMessageEditedInThreadEventData() {}

    /**
     * Get the messageBody property: The body of the chat message.
     *
     * @return the messageBody value.
     */
    public String getMessageBody() {
        return this.messageBody;
    }

    /**
     * Set the messageBody property: The body of the chat message.
     *
     * @param messageBody the messageBody value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    public AcsChatMessageEditedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    /**
     * Get the metadata property: The chat message metadata.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The chat message metadata.
     *
     * @param metadata the metadata value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    public AcsChatMessageEditedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the editTime property: The time at which the message was edited.
     *
     * @return the editTime value.
     */
    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    /**
     * Set the editTime property: The time at which the message was edited.
     *
     * @param editTime the editTime value to set.
     * @return the AcsChatMessageEditedInThreadEventData object itself.
     */
    public AcsChatMessageEditedInThreadEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setSenderCommunicationIdentifier(
            CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatMessageEditedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }
}
