// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Schema of the Data property of an EventGridEvent for a
 * Microsoft.Communication.ChatParticipantRemovedFromThreadWithUser event.
 */
@Fluent
public final class AcsChatParticipantRemovedFromThreadWithUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The time at which the user was removed to the thread
     */
    @JsonProperty(value = "time")
    private OffsetDateTime time;

    /*
     * The communication identifier of the user who removed the user
     */
    @JsonProperty(value = "removedByCommunicationIdentifier")
    private CommunicationIdentifierModel removedByCommunicationIdentifier;

    /*
     * The details of the user who was removed
     */
    @JsonProperty(value = "participantRemoved")
    private AcsChatThreadParticipantProperties participantRemoved;

    /** Creates an instance of AcsChatParticipantRemovedFromThreadWithUserEventData class. */
    public AcsChatParticipantRemovedFromThreadWithUserEventData() {}

    /**
     * Get the time property: The time at which the user was removed to the thread.
     *
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was removed to the thread.
     *
     * @param time the time value to set.
     * @return the AcsChatParticipantRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the removedByCommunicationIdentifier property: The communication identifier of the user who removed the user.
     *
     * @return the removedByCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getRemovedByCommunicationIdentifier() {
        return this.removedByCommunicationIdentifier;
    }

    /**
     * Set the removedByCommunicationIdentifier property: The communication identifier of the user who removed the user.
     *
     * @param removedByCommunicationIdentifier the removedByCommunicationIdentifier value to set.
     * @return the AcsChatParticipantRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadWithUserEventData setRemovedByCommunicationIdentifier(
            CommunicationIdentifierModel removedByCommunicationIdentifier) {
        this.removedByCommunicationIdentifier = removedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the participantRemoved property: The details of the user who was removed.
     *
     * @return the participantRemoved value.
     */
    public AcsChatThreadParticipantProperties getParticipantRemoved() {
        return this.participantRemoved;
    }

    /**
     * Set the participantRemoved property: The details of the user who was removed.
     *
     * @param participantRemoved the participantRemoved value to set.
     * @return the AcsChatParticipantRemovedFromThreadWithUserEventData object itself.
     */
    public AcsChatParticipantRemovedFromThreadWithUserEventData setParticipantRemoved(
            AcsChatThreadParticipantProperties participantRemoved) {
        this.participantRemoved = participantRemoved;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setRecipientCommunicationIdentifier(
            CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AcsChatParticipantRemovedFromThreadWithUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }
}
