// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Schema of the Data property of an EventGridEvent for a Microsoft.Communication.EmailDeliveryReportReceived event. */
@Fluent
public final class AcsEmailDeliveryReportReceivedEventData {
    /*
     * The Sender Email Address
     */
    @JsonProperty(value = "sender")
    private String sender;

    /*
     * The recipient Email Address
     */
    @JsonProperty(value = "recipient")
    private String recipient;

    /*
     * The Id of the email been sent
     */
    @JsonProperty(value = "messageId")
    private String messageId;

    /*
     * The status of the email. Any value other than Delivered is considered failed.
     */
    @JsonProperty(value = "status")
    private AcsEmailDeliveryReportStatus status;

    /*
     * Detailed information about the status if any
     */
    @JsonProperty(value = "deliveryStatusDetails")
    private AcsEmailDeliveryReportStatusDetails deliveryStatusDetails;

    /*
     * The time at which the email delivery report received timestamp
     */
    @JsonProperty(value = "deliveryAttemptTimeStamp")
    private OffsetDateTime deliveryAttemptTimestamp;

    /** Creates an instance of AcsEmailDeliveryReportReceivedEventData class. */
    public AcsEmailDeliveryReportReceivedEventData() {}

    /**
     * Get the sender property: The Sender Email Address.
     *
     * @return the sender value.
     */
    public String getSender() {
        return this.sender;
    }

    /**
     * Set the sender property: The Sender Email Address.
     *
     * @param sender the sender value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setSender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the recipient property: The recipient Email Address.
     *
     * @return the recipient value.
     */
    public String getRecipient() {
        return this.recipient;
    }

    /**
     * Set the recipient property: The recipient Email Address.
     *
     * @param recipient the recipient value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    /**
     * Get the messageId property: The Id of the email been sent.
     *
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The Id of the email been sent.
     *
     * @param messageId the messageId value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the status property: The status of the email. Any value other than Delivered is considered failed.
     *
     * @return the status value.
     */
    public AcsEmailDeliveryReportStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status of the email. Any value other than Delivered is considered failed.
     *
     * @param status the status value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setStatus(AcsEmailDeliveryReportStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the deliveryStatusDetails property: Detailed information about the status if any.
     *
     * @return the deliveryStatusDetails value.
     */
    public AcsEmailDeliveryReportStatusDetails getDeliveryStatusDetails() {
        return this.deliveryStatusDetails;
    }

    /**
     * Set the deliveryStatusDetails property: Detailed information about the status if any.
     *
     * @param deliveryStatusDetails the deliveryStatusDetails value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setDeliveryStatusDetails(
            AcsEmailDeliveryReportStatusDetails deliveryStatusDetails) {
        this.deliveryStatusDetails = deliveryStatusDetails;
        return this;
    }

    /**
     * Get the deliveryAttemptTimestamp property: The time at which the email delivery report received timestamp.
     *
     * @return the deliveryAttemptTimestamp value.
     */
    public OffsetDateTime getDeliveryAttemptTimestamp() {
        return this.deliveryAttemptTimestamp;
    }

    /**
     * Set the deliveryAttemptTimestamp property: The time at which the email delivery report received timestamp.
     *
     * @param deliveryAttemptTimestamp the deliveryAttemptTimestamp value to set.
     * @return the AcsEmailDeliveryReportReceivedEventData object itself.
     */
    public AcsEmailDeliveryReportReceivedEventData setDeliveryAttemptTimestamp(
            OffsetDateTime deliveryAttemptTimestamp) {
        this.deliveryAttemptTimestamp = deliveryAttemptTimestamp;
        return this;
    }
}
