// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The status of the email. Any value other than Delivered is considered failed. */
public final class AcsEmailDeliveryReportStatus extends ExpandableStringEnum<AcsEmailDeliveryReportStatus> {
    /** Hard bounce detected while sending the email. */
    public static final AcsEmailDeliveryReportStatus BOUNCED = fromString("Bounced");

    /** The email was delivered. */
    public static final AcsEmailDeliveryReportStatus DELIVERED = fromString("Delivered");

    /** The email failed to be delivered. */
    public static final AcsEmailDeliveryReportStatus FAILED = fromString("Failed");

    /** The message was identified spam and was rejected or blocked (not quarantined). */
    public static final AcsEmailDeliveryReportStatus FILTERED_SPAM = fromString("FilteredSpam");

    /**
     * The message was quarantined (as spam, bulk mail, or phishing). For more information, see Quarantined email
     * messages in EOP (EXCHANGE ONLINE PROTECTION).
     */
    public static final AcsEmailDeliveryReportStatus QUARANTINED = fromString("Quarantined");

    /** The email was suppressed. */
    public static final AcsEmailDeliveryReportStatus SUPPRESSED = fromString("Suppressed");

    /**
     * Creates a new instance of AcsEmailDeliveryReportStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AcsEmailDeliveryReportStatus() {}

    /**
     * Creates or finds a AcsEmailDeliveryReportStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AcsEmailDeliveryReportStatus.
     */
    @JsonCreator
    public static AcsEmailDeliveryReportStatus fromString(String name) {
        return fromString(name, AcsEmailDeliveryReportStatus.class);
    }

    /**
     * Gets known AcsEmailDeliveryReportStatus values.
     *
     * @return known AcsEmailDeliveryReportStatus values.
     */
    public static Collection<AcsEmailDeliveryReportStatus> values() {
        return values(AcsEmailDeliveryReportStatus.class);
    }
}
