// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for an Microsoft.Communication.UserDisconnected event. */
@Fluent
public final class AcsUserDisconnectedEventData {
    /*
     * The communication identifier of the user who was disconnected
     */
    @JsonProperty(value = "userCommunicationIdentifier")
    private CommunicationIdentifierModel userCommunicationIdentifier;

    /** Creates an instance of AcsUserDisconnectedEventData class. */
    public AcsUserDisconnectedEventData() {}

    /**
     * Get the userCommunicationIdentifier property: The communication identifier of the user who was disconnected.
     *
     * @return the userCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getUserCommunicationIdentifier() {
        return this.userCommunicationIdentifier;
    }

    /**
     * Set the userCommunicationIdentifier property: The communication identifier of the user who was disconnected.
     *
     * @param userCommunicationIdentifier the userCommunicationIdentifier value to set.
     * @return the AcsUserDisconnectedEventData object itself.
     */
    public AcsUserDisconnectedEventData setUserCommunicationIdentifier(
            CommunicationIdentifierModel userCommunicationIdentifier) {
        this.userCommunicationIdentifier = userCommunicationIdentifier;
        return this;
    }
}
