// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for a Microsoft.AppConfiguration.KeyValueDeleted event. */
@Fluent
public final class AppConfigurationKeyValueDeletedEventData {
    /*
     * The key used to identify the key-value that was deleted.
     */
    @JsonProperty(value = "key")
    private String key;

    /*
     * The label, if any, used to identify the key-value that was deleted.
     */
    @JsonProperty(value = "label")
    private String label;

    /*
     * The etag representing the key-value that was deleted.
     */
    @JsonProperty(value = "etag")
    private String etag;

    /*
     * The sync token representing the server state after the event.
     */
    @JsonProperty(value = "syncToken")
    private String syncToken;

    /** Creates an instance of AppConfigurationKeyValueDeletedEventData class. */
    public AppConfigurationKeyValueDeletedEventData() {}

    /**
     * Get the key property: The key used to identify the key-value that was deleted.
     *
     * @return the key value.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Set the key property: The key used to identify the key-value that was deleted.
     *
     * @param key the key value to set.
     * @return the AppConfigurationKeyValueDeletedEventData object itself.
     */
    public AppConfigurationKeyValueDeletedEventData setKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the label property: The label, if any, used to identify the key-value that was deleted.
     *
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: The label, if any, used to identify the key-value that was deleted.
     *
     * @param label the label value to set.
     * @return the AppConfigurationKeyValueDeletedEventData object itself.
     */
    public AppConfigurationKeyValueDeletedEventData setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the etag property: The etag representing the key-value that was deleted.
     *
     * @return the etag value.
     */
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: The etag representing the key-value that was deleted.
     *
     * @param etag the etag value to set.
     * @return the AppConfigurationKeyValueDeletedEventData object itself.
     */
    public AppConfigurationKeyValueDeletedEventData setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the syncToken property: The sync token representing the server state after the event.
     *
     * @return the syncToken value.
     */
    public String getSyncToken() {
        return this.syncToken;
    }

    /**
     * Set the syncToken property: The sync token representing the server state after the event.
     *
     * @param syncToken the syncToken value to set.
     * @return the AppConfigurationKeyValueDeletedEventData object itself.
     */
    public AppConfigurationKeyValueDeletedEventData setSyncToken(String syncToken) {
        this.syncToken = syncToken;
        return this;
    }
}
