// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Detail of action on the app service plan. */
@Fluent
public final class AppServicePlanEventTypeDetail {
    /*
     * Kind of environment where app service plan is.
     */
    @JsonProperty(value = "stampKind")
    private StampKind stampKind;

    /*
     * Type of action on the app service plan.
     */
    @JsonProperty(value = "action")
    private AppServicePlanAction action;

    /*
     * Asynchronous operation status of the operation on the app service plan.
     */
    @JsonProperty(value = "status")
    private AsyncStatus status;

    /** Creates an instance of AppServicePlanEventTypeDetail class. */
    public AppServicePlanEventTypeDetail() {}

    /**
     * Get the stampKind property: Kind of environment where app service plan is.
     *
     * @return the stampKind value.
     */
    public StampKind getStampKind() {
        return this.stampKind;
    }

    /**
     * Set the stampKind property: Kind of environment where app service plan is.
     *
     * @param stampKind the stampKind value to set.
     * @return the AppServicePlanEventTypeDetail object itself.
     */
    public AppServicePlanEventTypeDetail setStampKind(StampKind stampKind) {
        this.stampKind = stampKind;
        return this;
    }

    /**
     * Get the action property: Type of action on the app service plan.
     *
     * @return the action value.
     */
    public AppServicePlanAction getAction() {
        return this.action;
    }

    /**
     * Set the action property: Type of action on the app service plan.
     *
     * @param action the action value to set.
     * @return the AppServicePlanEventTypeDetail object itself.
     */
    public AppServicePlanEventTypeDetail setAction(AppServicePlanAction action) {
        this.action = action;
        return this;
    }

    /**
     * Get the status property: Asynchronous operation status of the operation on the app service plan.
     *
     * @return the status value.
     */
    public AsyncStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Asynchronous operation status of the operation on the app service plan.
     *
     * @param status the status value to set.
     * @return the AppServicePlanEventTypeDetail object itself.
     */
    public AppServicePlanEventTypeDetail setStatus(AsyncStatus status) {
        this.status = status;
        return this;
    }
}
