// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The content of the event request message. */
@Fluent
public class ContainerRegistryArtifactEventData {
    /*
     * The event ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The time at which the event occurred.
     */
    @JsonProperty(value = "timestamp")
    private OffsetDateTime timestamp;

    /*
     * The action that encompasses the provided event.
     */
    @JsonProperty(value = "action")
    private String action;

    /*
     * The location of the event.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The target of the event.
     */
    @JsonProperty(value = "target")
    private ContainerRegistryArtifactEventTarget target;

    /*
     * The connected registry information if the event is generated by a connected registry.
     */
    @JsonProperty(value = "connectedRegistry")
    private ContainerRegistryEventConnectedRegistry connectedRegistry;

    /** Creates an instance of ContainerRegistryArtifactEventData class. */
    public ContainerRegistryArtifactEventData() {}

    /**
     * Get the id property: The event ID.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: The event ID.
     *
     * @param id the id value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the timestamp property: The time at which the event occurred.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: The time at which the event occurred.
     *
     * @param timestamp the timestamp value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the action property: The action that encompasses the provided event.
     *
     * @return the action value.
     */
    public String getAction() {
        return this.action;
    }

    /**
     * Set the action property: The action that encompasses the provided event.
     *
     * @param action the action value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setAction(String action) {
        this.action = action;
        return this;
    }

    /**
     * Get the location property: The location of the event.
     *
     * @return the location value.
     */
    public String getLocation() {
        return this.location;
    }

    /**
     * Set the location property: The location of the event.
     *
     * @param location the location value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the target property: The target of the event.
     *
     * @return the target value.
     */
    public ContainerRegistryArtifactEventTarget getTarget() {
        return this.target;
    }

    /**
     * Set the target property: The target of the event.
     *
     * @param target the target value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setTarget(ContainerRegistryArtifactEventTarget target) {
        this.target = target;
        return this;
    }

    /**
     * Get the connectedRegistry property: The connected registry information if the event is generated by a connected
     * registry.
     *
     * @return the connectedRegistry value.
     */
    public ContainerRegistryEventConnectedRegistry getConnectedRegistry() {
        return this.connectedRegistry;
    }

    /**
     * Set the connectedRegistry property: The connected registry information if the event is generated by a connected
     * registry.
     *
     * @param connectedRegistry the connectedRegistry value to set.
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData setConnectedRegistry(
            ContainerRegistryEventConnectedRegistry connectedRegistry) {
        this.connectedRegistry = connectedRegistry;
        return this;
    }
}
