// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ContainerService.NewKubernetesVersionAvailable
 * event.
 */
@Fluent
public final class ContainerServiceNewKubernetesVersionAvailableEventData {
    /*
     * The highest PATCH Kubernetes version for the highest MINOR version supported by ManagedCluster resource
     */
    @JsonProperty(value = "latestSupportedKubernetesVersion")
    private String latestSupportedKubernetesVersion;

    /*
     * The highest PATCH Kubernetes version for the MINOR version considered stable for the ManagedCluster resource
     */
    @JsonProperty(value = "latestStableKubernetesVersion")
    private String latestStableKubernetesVersion;

    /*
     * The highest PATCH Kubernetes version for the lowest applicable MINOR version available for the ManagedCluster
     * resource
     */
    @JsonProperty(value = "lowestMinorKubernetesVersion")
    private String lowestMinorKubernetesVersion;

    /*
     * The highest PATCH Kubernetes version considered preview for the ManagedCluster resource. There might not be any
     * version in preview at the time of publishing the event
     */
    @JsonProperty(value = "latestPreviewKubernetesVersion")
    private String latestPreviewKubernetesVersion;

    /** Creates an instance of ContainerServiceNewKubernetesVersionAvailableEventData class. */
    public ContainerServiceNewKubernetesVersionAvailableEventData() {}

    /**
     * Get the latestSupportedKubernetesVersion property: The highest PATCH Kubernetes version for the highest MINOR
     * version supported by ManagedCluster resource.
     *
     * @return the latestSupportedKubernetesVersion value.
     */
    public String getLatestSupportedKubernetesVersion() {
        return this.latestSupportedKubernetesVersion;
    }

    /**
     * Set the latestSupportedKubernetesVersion property: The highest PATCH Kubernetes version for the highest MINOR
     * version supported by ManagedCluster resource.
     *
     * @param latestSupportedKubernetesVersion the latestSupportedKubernetesVersion value to set.
     * @return the ContainerServiceNewKubernetesVersionAvailableEventData object itself.
     */
    public ContainerServiceNewKubernetesVersionAvailableEventData setLatestSupportedKubernetesVersion(
            String latestSupportedKubernetesVersion) {
        this.latestSupportedKubernetesVersion = latestSupportedKubernetesVersion;
        return this;
    }

    /**
     * Get the latestStableKubernetesVersion property: The highest PATCH Kubernetes version for the MINOR version
     * considered stable for the ManagedCluster resource.
     *
     * @return the latestStableKubernetesVersion value.
     */
    public String getLatestStableKubernetesVersion() {
        return this.latestStableKubernetesVersion;
    }

    /**
     * Set the latestStableKubernetesVersion property: The highest PATCH Kubernetes version for the MINOR version
     * considered stable for the ManagedCluster resource.
     *
     * @param latestStableKubernetesVersion the latestStableKubernetesVersion value to set.
     * @return the ContainerServiceNewKubernetesVersionAvailableEventData object itself.
     */
    public ContainerServiceNewKubernetesVersionAvailableEventData setLatestStableKubernetesVersion(
            String latestStableKubernetesVersion) {
        this.latestStableKubernetesVersion = latestStableKubernetesVersion;
        return this;
    }

    /**
     * Get the lowestMinorKubernetesVersion property: The highest PATCH Kubernetes version for the lowest applicable
     * MINOR version available for the ManagedCluster resource.
     *
     * @return the lowestMinorKubernetesVersion value.
     */
    public String getLowestMinorKubernetesVersion() {
        return this.lowestMinorKubernetesVersion;
    }

    /**
     * Set the lowestMinorKubernetesVersion property: The highest PATCH Kubernetes version for the lowest applicable
     * MINOR version available for the ManagedCluster resource.
     *
     * @param lowestMinorKubernetesVersion the lowestMinorKubernetesVersion value to set.
     * @return the ContainerServiceNewKubernetesVersionAvailableEventData object itself.
     */
    public ContainerServiceNewKubernetesVersionAvailableEventData setLowestMinorKubernetesVersion(
            String lowestMinorKubernetesVersion) {
        this.lowestMinorKubernetesVersion = lowestMinorKubernetesVersion;
        return this;
    }

    /**
     * Get the latestPreviewKubernetesVersion property: The highest PATCH Kubernetes version considered preview for the
     * ManagedCluster resource. There might not be any version in preview at the time of publishing the event.
     *
     * @return the latestPreviewKubernetesVersion value.
     */
    public String getLatestPreviewKubernetesVersion() {
        return this.latestPreviewKubernetesVersion;
    }

    /**
     * Set the latestPreviewKubernetesVersion property: The highest PATCH Kubernetes version considered preview for the
     * ManagedCluster resource. There might not be any version in preview at the time of publishing the event.
     *
     * @param latestPreviewKubernetesVersion the latestPreviewKubernetesVersion value to set.
     * @return the ContainerServiceNewKubernetesVersionAvailableEventData object itself.
     */
    public ContainerServiceNewKubernetesVersionAvailableEventData setLatestPreviewKubernetesVersion(
            String latestPreviewKubernetesVersion) {
        this.latestPreviewKubernetesVersion = latestPreviewKubernetesVersion;
        return this;
    }
}
