// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties JSON element. */
@Fluent
public final class DeviceTwinInfoProperties {
    /*
     * A portion of the properties that can be written only by the application back-end, and read by the device.
     */
    @JsonProperty(value = "desired")
    private DeviceTwinProperties desired;

    /*
     * A portion of the properties that can be written only by the device, and read by the application back-end.
     */
    @JsonProperty(value = "reported")
    private DeviceTwinProperties reported;

    /** Creates an instance of DeviceTwinInfoProperties class. */
    public DeviceTwinInfoProperties() {}

    /**
     * Get the desired property: A portion of the properties that can be written only by the application back-end, and
     * read by the device.
     *
     * @return the desired value.
     */
    public DeviceTwinProperties getDesired() {
        return this.desired;
    }

    /**
     * Set the desired property: A portion of the properties that can be written only by the application back-end, and
     * read by the device.
     *
     * @param desired the desired value to set.
     * @return the DeviceTwinInfoProperties object itself.
     */
    public DeviceTwinInfoProperties setDesired(DeviceTwinProperties desired) {
        this.desired = desired;
        return this;
    }

    /**
     * Get the reported property: A portion of the properties that can be written only by the device, and read by the
     * application back-end.
     *
     * @return the reported value.
     */
    public DeviceTwinProperties getReported() {
        return this.reported;
    }

    /**
     * Set the reported property: A portion of the properties that can be written only by the device, and read by the
     * application back-end.
     *
     * @param reported the reported value to set.
     * @return the DeviceTwinInfoProperties object itself.
     */
    public DeviceTwinInfoProperties setReported(DeviceTwinProperties reported) {
        this.reported = reported;
        return this;
    }
}
