// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for a Microsoft.HealthcareApis.DicomImageUpdated event. */
@Fluent
public final class HealthcareDicomImageUpdatedEventData {
    /*
     * Data partition name
     */
    @JsonProperty(value = "partitionName")
    private String partitionName;

    /*
     * Unique identifier for the Study
     */
    @JsonProperty(value = "imageStudyInstanceUid")
    private String imageStudyInstanceUid;

    /*
     * Unique identifier for the Series
     */
    @JsonProperty(value = "imageSeriesInstanceUid")
    private String imageSeriesInstanceUid;

    /*
     * Unique identifier for the DICOM Image
     */
    @JsonProperty(value = "imageSopInstanceUid")
    private String imageSopInstanceUid;

    /*
     * Domain name of the DICOM account for this image.
     */
    @JsonProperty(value = "serviceHostName")
    private String serviceHostName;

    /*
     * Sequence number of the DICOM Service within Azure Health Data Services. It is unique for every image creation,
     * updation and deletion within the service.
     */
    @JsonProperty(value = "sequenceNumber")
    private Long sequenceNumber;

    /** Creates an instance of HealthcareDicomImageUpdatedEventData class. */
    public HealthcareDicomImageUpdatedEventData() {}

    /**
     * Get the partitionName property: Data partition name.
     *
     * @return the partitionName value.
     */
    public String getPartitionName() {
        return this.partitionName;
    }

    /**
     * Set the partitionName property: Data partition name.
     *
     * @param partitionName the partitionName value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setPartitionName(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    /**
     * Get the imageStudyInstanceUid property: Unique identifier for the Study.
     *
     * @return the imageStudyInstanceUid value.
     */
    public String getImageStudyInstanceUid() {
        return this.imageStudyInstanceUid;
    }

    /**
     * Set the imageStudyInstanceUid property: Unique identifier for the Study.
     *
     * @param imageStudyInstanceUid the imageStudyInstanceUid value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setImageStudyInstanceUid(String imageStudyInstanceUid) {
        this.imageStudyInstanceUid = imageStudyInstanceUid;
        return this;
    }

    /**
     * Get the imageSeriesInstanceUid property: Unique identifier for the Series.
     *
     * @return the imageSeriesInstanceUid value.
     */
    public String getImageSeriesInstanceUid() {
        return this.imageSeriesInstanceUid;
    }

    /**
     * Set the imageSeriesInstanceUid property: Unique identifier for the Series.
     *
     * @param imageSeriesInstanceUid the imageSeriesInstanceUid value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setImageSeriesInstanceUid(String imageSeriesInstanceUid) {
        this.imageSeriesInstanceUid = imageSeriesInstanceUid;
        return this;
    }

    /**
     * Get the imageSopInstanceUid property: Unique identifier for the DICOM Image.
     *
     * @return the imageSopInstanceUid value.
     */
    public String getImageSopInstanceUid() {
        return this.imageSopInstanceUid;
    }

    /**
     * Set the imageSopInstanceUid property: Unique identifier for the DICOM Image.
     *
     * @param imageSopInstanceUid the imageSopInstanceUid value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setImageSopInstanceUid(String imageSopInstanceUid) {
        this.imageSopInstanceUid = imageSopInstanceUid;
        return this;
    }

    /**
     * Get the serviceHostName property: Domain name of the DICOM account for this image.
     *
     * @return the serviceHostName value.
     */
    public String getServiceHostName() {
        return this.serviceHostName;
    }

    /**
     * Set the serviceHostName property: Domain name of the DICOM account for this image.
     *
     * @param serviceHostName the serviceHostName value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setServiceHostName(String serviceHostName) {
        this.serviceHostName = serviceHostName;
        return this;
    }

    /**
     * Get the sequenceNumber property: Sequence number of the DICOM Service within Azure Health Data Services. It is
     * unique for every image creation, updation and deletion within the service.
     *
     * @return the sequenceNumber value.
     */
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * Set the sequenceNumber property: Sequence number of the DICOM Service within Azure Health Data Services. It is
     * unique for every image creation, updation and deletion within the service.
     *
     * @param sequenceNumber the sequenceNumber value to set.
     * @return the HealthcareDicomImageUpdatedEventData object itself.
     */
    public HealthcareDicomImageUpdatedEventData setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }
}
