// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Schema of the Data property of an EventGridEvent for a Microsoft.HealthcareApis.FhirResourceDeleted event. */
@Fluent
public final class HealthcareFhirResourceDeletedEventData {
    /*
     * Type of HL7 FHIR resource.
     */
    @JsonProperty(value = "resourceType")
    private HealthcareFhirResourceType fhirResourceType;

    /*
     * Domain name of FHIR account for this resource.
     */
    @JsonProperty(value = "resourceFhirAccount")
    private String fhirServiceHostName;

    /*
     * Id of HL7 FHIR resource.
     */
    @JsonProperty(value = "resourceFhirId")
    private String fhirResourceId;

    /*
     * VersionId of HL7 FHIR resource. It changes when the resource is created, updated, or deleted(soft-deletion).
     */
    @JsonProperty(value = "resourceVersionId")
    private Long fhirResourceVersionId;

    /** Creates an instance of HealthcareFhirResourceDeletedEventData class. */
    public HealthcareFhirResourceDeletedEventData() {}

    /**
     * Get the fhirResourceType property: Type of HL7 FHIR resource.
     *
     * @return the fhirResourceType value.
     */
    public HealthcareFhirResourceType getFhirResourceType() {
        return this.fhirResourceType;
    }

    /**
     * Set the fhirResourceType property: Type of HL7 FHIR resource.
     *
     * @param fhirResourceType the fhirResourceType value to set.
     * @return the HealthcareFhirResourceDeletedEventData object itself.
     */
    public HealthcareFhirResourceDeletedEventData setFhirResourceType(HealthcareFhirResourceType fhirResourceType) {
        this.fhirResourceType = fhirResourceType;
        return this;
    }

    /**
     * Get the fhirServiceHostName property: Domain name of FHIR account for this resource.
     *
     * @return the fhirServiceHostName value.
     */
    public String getFhirServiceHostName() {
        return this.fhirServiceHostName;
    }

    /**
     * Set the fhirServiceHostName property: Domain name of FHIR account for this resource.
     *
     * @param fhirServiceHostName the fhirServiceHostName value to set.
     * @return the HealthcareFhirResourceDeletedEventData object itself.
     */
    public HealthcareFhirResourceDeletedEventData setFhirServiceHostName(String fhirServiceHostName) {
        this.fhirServiceHostName = fhirServiceHostName;
        return this;
    }

    /**
     * Get the fhirResourceId property: Id of HL7 FHIR resource.
     *
     * @return the fhirResourceId value.
     */
    public String getFhirResourceId() {
        return this.fhirResourceId;
    }

    /**
     * Set the fhirResourceId property: Id of HL7 FHIR resource.
     *
     * @param fhirResourceId the fhirResourceId value to set.
     * @return the HealthcareFhirResourceDeletedEventData object itself.
     */
    public HealthcareFhirResourceDeletedEventData setFhirResourceId(String fhirResourceId) {
        this.fhirResourceId = fhirResourceId;
        return this;
    }

    /**
     * Get the fhirResourceVersionId property: VersionId of HL7 FHIR resource. It changes when the resource is created,
     * updated, or deleted(soft-deletion).
     *
     * @return the fhirResourceVersionId value.
     */
    public Long getFhirResourceVersionId() {
        return this.fhirResourceVersionId;
    }

    /**
     * Set the fhirResourceVersionId property: VersionId of HL7 FHIR resource. It changes when the resource is created,
     * updated, or deleted(soft-deletion).
     *
     * @param fhirResourceVersionId the fhirResourceVersionId value to set.
     * @return the HealthcareFhirResourceDeletedEventData object itself.
     */
    public HealthcareFhirResourceDeletedEventData setFhirResourceVersionId(Long fhirResourceVersionId) {
        this.fhirResourceVersionId = fhirResourceVersionId;
        return this;
    }
}
